/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm.msg;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import rath.msnm.SwitchboardSession;
import rath.msnm.msg.MimeMessage;

public class WebcamMessage
extends MimeMessage {
    private static final Random random = new Random(System.currentTimeMillis());
    private static String host = null;

    private WebcamMessage() {
        this.setKind(3);
    }

    public static WebcamMessage createInviteMessage(SwitchboardSession session, String host, int port) {
        int cookie = random.nextInt(999998) + 1;
        WebcamMessage msg = new WebcamMessage();
        msg.setProperty("Application-Name", "viewing webcam");
        msg.setProperty("Application-GUID", "2A23868E-B45F-401d-B8B0-1E16B774A5B7");
        msg.setProperty("Session-Protocol", "SM1");
        msg.setProperty("Invitation-Command", "INVITE");
        msg.setProperty("Invitation-Cookie", String.valueOf(cookie));
        msg.setProperty("Session-ID", session.getSessionId());
        msg.setProperty("Port", String.valueOf(port));
        msg.setProperty("IP", host);
        return msg;
    }

    public static WebcamMessage createAcceptMessage(SwitchboardSession session, int cookie, String host, String port) {
        if (cookie < 1) {
            throw new IllegalArgumentException("cookie must larger than 0");
        }
        WebcamMessage msg = new WebcamMessage();
        msg.setProperty("Launch-Application", "TRUE");
        msg.setProperty("IP-Address", host);
        msg.setProperty("Session-Protocol", "SM1");
        msg.setProperty("Request-Data", "IP-Address:");
        msg.setProperty("Invitation-Command", "ACCEPT");
        msg.setProperty("Invitation-Cookie", String.valueOf(cookie));
        msg.setProperty("Session-ID", session.getSessionId());
        msg.setProperty("Port", port);
        return msg;
    }

    public static WebcamMessage createRejectMessage(SwitchboardSession session, int cookie) {
        if (cookie < 1) {
            throw new IllegalArgumentException("cookie must larger than 0");
        }
        WebcamMessage msg = new WebcamMessage();
        msg.setProperty("Session-Protocol", "SM1");
        msg.setProperty("Cancel-Code", "REJECT");
        msg.setProperty("Invitation-Command", "CANCEL");
        msg.setProperty("Invitation-Cookie", String.valueOf(cookie));
        msg.setProperty("Session-ID", session.getSessionId());
        return msg;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        StringBuffer buf = this.createMimeHeader("text/x-msmsgsinvite; charset=UTF-8");
        buf.append("\r\n");
        this.fillMimeProperties(buf);
        buf.append("\r\n");
        String msg = buf.toString();
        return msg.getBytes("UTF-8");
    }

    public static String getIP() throws UnknownHostException {
        InetAddress localaddr = InetAddress.getLocalHost();
        InetAddress[] localaddrs = InetAddress.getAllByName(localaddr.getHostName());
        for (int i = 0; i < localaddrs.length; ++i) {
            if (localaddrs[i].equals(localaddr)) continue;
            String host = localaddrs[i].getHostAddress();
            return host;
        }
        return null;
    }

    public static String getIP2() {
        try {
            host = InetAddress.getLocalHost().getHostAddress();
            return host;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String getIP3() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] ipAddr = addr.getAddress();
            addr = InetAddress.getByName(addr.getHostName());
            ipAddr = addr.getAddress();
            String ipAddrStr = "";
            for (int i = 0; i < ipAddr.length; ++i) {
                if (i > 0) {
                    ipAddrStr = ipAddrStr + ".";
                }
                ipAddrStr = ipAddrStr + (ipAddr[i] & 0xFF);
            }
            return ipAddrStr;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            System.err.println("host:" + WebcamMessage.getIP());
            System.err.println("host:" + WebcamMessage.getIP2());
            System.err.println("host:" + WebcamMessage.getIP3());
        }
        catch (UnknownHostException e) {
            System.err.println("Can't detect localhost : " + e);
        }
    }
}

