/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnClassLoader;
import org.zaproxy.zap.control.AddOnLoaderUtils;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.control.PostponedTasksRunner;
import org.zaproxy.zap.utils.ZapResourceBundleControl;

public final class AddOnInstaller {
    private static final Logger LOGGER = LogManager.getLogger(AddOnInstaller.class);
    private static final String ADD_ON_DATA_DIR = "addOnData";
    private static final String ADD_ON_DATA_LIBS_DIR = "libs";

    private AddOnInstaller() {
    }

    public static void install(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOnInstaller.installResourceBundle(addOnClassLoader, addOn);
        AddOnInstaller.installAddOnFiles(addOnClassLoader, addOn, true);
        List<Extension> listExts = AddOnInstaller.installAddOnExtensions(addOn);
        AddOnInstaller.installAddOnActiveScanRules(addOn, addOnClassLoader);
        for (Extension ext : listExts) {
            if (!ext.isEnabled()) continue;
            try {
                ext.postInstall();
            }
            catch (Exception e) {
                LOGGER.error("Post install method failed for add-on {} extension {}", (Object)addOn.getId(), (Object)ext.getName(), (Object)e);
            }
        }
    }

    @Deprecated
    public static boolean uninstall(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        return AddOnInstaller.uninstall(addOn, callback, null);
    }

    @Deprecated
    public static boolean uninstall(AddOn addOn, AddOnUninstallationProgressCallback callback, Set<AddOn> installedAddOns) {
        return AddOnInstaller.uninstall(addOn, callback, installedAddOns, null);
    }

    public static boolean uninstall(AddOn addOn, AddOnUninstallationProgressCallback callback, Set<AddOn> installedAddOns, PostponedTasksRunner postponedTasks) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.", (Object[])new Object[0]);
        AddOnInstaller.validateCallbackNotNull(callback);
        boolean uninstalledWithoutErrors = AddOnInstaller.softUninstall(addOn, callback);
        return uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnFiles(addOn, callback, installedAddOns, postponedTasks);
    }

    public static boolean softUninstall(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.", (Object[])new Object[0]);
        AddOnInstaller.validateCallbackNotNull(callback);
        try {
            boolean uninstalledWithoutErrors = true;
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnActiveScanRules(addOn, callback);
            AddOnInstaller.uninstallResourceBundle(addOn);
            return uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnExtensions(addOn, callback);
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while uninstalling the add-on: {}", (Object)addOn.getId(), (Object)e);
            return false;
        }
    }

    static void installResourceBundle(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOn.BundleData bundleData = addOn.getBundleData();
        if (bundleData.isEmpty()) {
            return;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleData.getBaseName(), Constant.getLocale(), addOnClassLoader, new ZapResourceBundleControl());
            addOn.setResourceBundle(resourceBundle);
            String bundlePrefix = bundleData.getPrefix();
            if (!bundlePrefix.isEmpty()) {
                Constant.messages.addMessageBundle(bundlePrefix, resourceBundle);
            }
        }
        catch (MissingResourceException e) {
            LOGGER.error("Declared bundle not found in {} add-on:", (Object)addOn.getId(), (Object)e);
        }
    }

    private static void uninstallResourceBundle(AddOn addOn) {
        String bundlePrefix = addOn.getBundleData().getPrefix();
        if (!bundlePrefix.isEmpty()) {
            Constant.messages.removeMessageBundle(bundlePrefix);
        }
    }

    private static List<Extension> installAddOnExtensions(AddOn addOn) {
        ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
        List<Extension> listExts = ExtensionFactory.loadAddOnExtensions(extensionLoader, (Configuration)Model.getSingleton().getOptionsParam().getConfig(), addOn);
        for (Extension ext : listExts) {
            AddOnInstaller.installAddOnExtensionImpl(addOn, ext, extensionLoader);
        }
        return listExts;
    }

    public static void installAddOnExtension(AddOn addOn, Extension ext) {
        ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
        ExtensionFactory.addAddOnExtension(extensionLoader, (Configuration)Model.getSingleton().getOptionsParam().getConfig(), ext);
        AddOnInstaller.installAddOnExtensionImpl(addOn, ext, extensionLoader);
    }

    private static void installAddOnExtensionImpl(AddOn addOn, Extension ext, ExtensionLoader extensionLoader) {
        if (ext.isEnabled()) {
            LOGGER.debug("Starting extension {}", (Object)ext.getName());
            try {
                extensionLoader.startLifeCycle(ext);
            }
            catch (Throwable e) {
                LOGGER.error("An error occurred while installing the add-on: {}", (Object)addOn.getId(), (Object)e);
            }
        }
    }

    private static boolean uninstallAddOnExtensions(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        callback.extensionsWillBeRemoved(addOn.getLoadedExtensions().size());
        ArrayList<Extension> extensions = new ArrayList<Extension>(addOn.getLoadedExtensions());
        Collections.reverse(extensions);
        for (Extension ext : extensions) {
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnExtension(addOn, ext, callback);
        }
        return uninstalledWithoutErrors;
    }

    protected static boolean uninstallAddOnExtension(AddOn addOn, Extension extension, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        if (extension.isEnabled()) {
            String extUiName = extension.getUIName();
            if (extension.canUnload()) {
                LOGGER.debug("Unloading extension: {}", (Object)extension.getName());
                try {
                    extension.unload();
                    Control.getSingleton().getExtensionLoader().removeExtension(extension);
                    ExtensionFactory.unloadAddOnExtension(extension);
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while uninstalling the extension \"{}\" bundled in the add-on \"{}\":", (Object)extension.getName(), (Object)addOn.getId(), (Object)e);
                    uninstalledWithoutErrors = false;
                }
            } else {
                LOGGER.debug("Can't dynamically unload extension: {}", (Object)extension.getName());
                uninstalledWithoutErrors = false;
            }
            callback.extensionRemoved(extUiName);
        } else {
            ExtensionFactory.unloadAddOnExtension(extension);
        }
        addOn.removeLoadedExtension(extension);
        return uninstalledWithoutErrors;
    }

    private static void installAddOnActiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        List<AbstractPlugin> ascanrules = AddOnLoaderUtils.getActiveScanRules(addOn, addOnClassLoader);
        if (!ascanrules.isEmpty()) {
            for (AbstractPlugin ascanrule : ascanrules) {
                String name = ascanrule.getClass().getCanonicalName();
                LOGGER.debug("Install ascanrule: {}", (Object)name);
                PluginFactory.loadedPlugin(ascanrule);
                if (PluginFactory.isPluginLoaded(ascanrule)) continue;
                LOGGER.error("Failed to install ascanrule: {}", (Object)name);
            }
        }
    }

    private static boolean uninstallAddOnActiveScanRules(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        List<AbstractPlugin> loadedAscanrules = addOn.getLoadedAscanrules();
        if (!loadedAscanrules.isEmpty()) {
            LOGGER.debug("Uninstall ascanrules: {}", addOn.getAscanrules());
            callback.activeScanRulesWillBeRemoved(loadedAscanrules.size());
            for (AbstractPlugin ascanrule : loadedAscanrules) {
                String name = ascanrule.getClass().getCanonicalName();
                LOGGER.debug("Uninstall ascanrule: {}", (Object)name);
                PluginFactory.unloadedPlugin(ascanrule);
                if (PluginFactory.isPluginLoaded(ascanrule)) {
                    LOGGER.error("Failed to uninstall ascanrule: {}", (Object)name);
                    uninstalledWithoutErrors = false;
                }
                callback.activeScanRuleRemoved(name);
            }
            addOn.setLoadedAscanrules(Collections.emptyList());
            addOn.setLoadedAscanrulesSet(false);
        }
        return uninstalledWithoutErrors;
    }

    static boolean installAddOnLibs(AddOn addOn) {
        return AddOnInstaller.installAddOnLibs(addOn, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean installAddOnLibs(AddOn addOn, boolean overwrite) {
        List<AddOn.Lib> libs = addOn.getLibs();
        if (libs.isEmpty()) {
            return true;
        }
        Path targetDir = AddOnInstaller.getAddOnLibsDir(addOn);
        try {
            Files.createDirectories(targetDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create libs directory for {}", (Object)addOn.getId(), (Object)e);
            return false;
        }
        try (ZipFile zip = new ZipFile(addOn.getFile());){
            Iterator<AddOn.Lib> iterator = libs.iterator();
            while (iterator.hasNext()) {
                AddOn.Lib lib = iterator.next();
                String name = lib.getName();
                LOGGER.debug("Installing library for {}: {}", (Object)addOn, (Object)name);
                Path targetFile = targetDir.resolve(name);
                try {
                    lib.setFileSystemUrl(targetFile.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.warn("Failed to convert lib's filesystem path to URL for {}", (Object)addOn.getId(), (Object)e);
                    boolean bl = false;
                    zip.close();
                    return bl;
                }
                if (!overwrite && Files.exists(targetFile, new LinkOption[0])) continue;
                ZipEntry libZipEntry = zip.getEntry(lib.getJarPath());
                if (libZipEntry == null) {
                    LOGGER.warn("Library not found in {} add-on: {}", (Object)addOn, (Object)lib);
                    boolean bl = false;
                    return bl;
                }
                try {
                    InputStream in = zip.getInputStream(libZipEntry);
                    try {
                        Files.copy(in, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to copy the library for {}: {}", (Object)addOn, (Object)targetFile, (Object)e);
                    boolean bl = false;
                    zip.close();
                    return bl;
                }
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while installing libraries for {}", (Object)addOn, (Object)e);
            return false;
        }
    }

    static Path getAddOnDataDir(AddOn addOn) {
        return Paths.get(Constant.getZapHome(), ADD_ON_DATA_DIR, addOn.getId(), addOn.getVersion().toString());
    }

    static void deleteLegacyAddOnLibsDir(List<AddOn> addOns) {
        for (AddOn addOn : addOns) {
            Path libsDir = Paths.get(Constant.getZapHome(), ADD_ON_DATA_DIR, addOn.getId(), ADD_ON_DATA_LIBS_DIR);
            try {
                AddOnInstaller.deleteDir(libsDir);
            }
            catch (IOException e) {
                LOGGER.warn("An error occurred while removing legacy add-on libs directory {}", (Object)libsDir, (Object)e);
            }
        }
    }

    static Path getAddOnLibsDir(AddOn addOn) {
        return AddOnInstaller.getAddOnDataDir(addOn).resolve(ADD_ON_DATA_LIBS_DIR);
    }

    static boolean installMissingAddOnLibs(AddOn addOn) {
        return AddOnInstaller.installAddOnLibs(addOn, false);
    }

    static boolean uninstallAddOnLibs(AddOn addOn) {
        List<AddOn.Lib> libs = addOn.getLibs();
        if (libs.isEmpty()) {
            return true;
        }
        Path addOnLibsDir = AddOnInstaller.getAddOnLibsDir(addOn);
        try {
            AddOnInstaller.deleteDir(addOnLibsDir);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while uninstalling libraries for {}", (Object)addOn, (Object)e);
            return false;
        }
        Path addOnDataDir = addOnLibsDir.getParent();
        try (Stream<Path> entries = Files.list(addOnDataDir);){
            if (!entries.findAny().isPresent()) {
                Files.delete(addOnDataDir);
            }
        }
        catch (IOException e) {
            LOGGER.warn("An error occurred while removing the directory {}", (Object)addOnDataDir, (Object)e);
            return false;
        }
        return true;
    }

    private static void deleteDir(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e != null) {
                    throw e;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void installMissingAddOnFiles(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOnInstaller.installAddOnFiles(addOnClassLoader, addOn, false);
    }

    public static void updateAddOnFiles(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOnInstaller.installAddOnFiles(addOnClassLoader, addOn, true);
    }

    private static void installAddOnFiles(AddOnClassLoader addOnClassLoader, AddOn addOn, boolean overwrite) {
        List<String> fileNames = addOn.getFiles();
        if (fileNames == null || fileNames.isEmpty()) {
            return;
        }
        for (String name : fileNames) {
            File outfile = new File(Constant.getZapHome(), name);
            if (!overwrite && outfile.exists()) continue;
            if (!outfile.getParentFile().exists() && !outfile.getParentFile().mkdirs()) {
                LOGGER.error("Failed to create directories for add-on {}: {}", (Object)addOn, (Object)outfile.getAbsolutePath());
                continue;
            }
            LOGGER.debug("Installing file: {}", (Object)name);
            URL fileURL = addOnClassLoader.findResource(name);
            if (fileURL == null) {
                LOGGER.error("File not found in add-on {}: {}", (Object)addOn, (Object)name);
                continue;
            }
            try {
                InputStream in = fileURL.openStream();
                try (FileOutputStream out = new FileOutputStream(outfile);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to install a file from add-on {}: {}", (Object)addOn, (Object)outfile.getAbsolutePath(), (Object)e);
            }
        }
        Control.getSingleton().getExtensionLoader().addonFilesAdded();
    }

    private static void validateCallbackNotNull(AddOnUninstallationProgressCallback callback) {
        Validate.notNull((Object)callback, (String)"Parameter callback must not be null.", (Object[])new Object[0]);
    }

    @Deprecated
    public static boolean uninstallAddOnFiles(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        return AddOnInstaller.uninstallAddOnFiles(addOn, callback, null);
    }

    @Deprecated
    public static boolean uninstallAddOnFiles(AddOn addOn, AddOnUninstallationProgressCallback callback, Set<AddOn> installedAddOns) {
        return AddOnInstaller.uninstallAddOnFiles(addOn, callback, installedAddOns, null);
    }

    public static boolean uninstallAddOnFiles(AddOn addOn, AddOnUninstallationProgressCallback callback, Set<AddOn> installedAddOns, PostponedTasksRunner postponedTasks) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.", (Object[])new Object[0]);
        AddOnInstaller.validateCallbackNotNull(callback);
        List<String> fileNames = AddOnInstaller.getFilesSafeForUninstall(addOn, installedAddOns == null ? Collections.emptySet() : installedAddOns);
        if (fileNames.isEmpty()) {
            return true;
        }
        callback.filesWillBeRemoved(fileNames.size());
        boolean uninstalledWithoutErrors = true;
        for (String name : fileNames) {
            if (name == null) continue;
            LOGGER.debug("Uninstall file: {}", (Object)name);
            File file = new File(Constant.getZapHome(), name);
            try {
                File parent = file.getParentFile();
                if (file.exists() && !file.delete()) {
                    LOGGER.error("Failed to delete: {}", (Object)file.getAbsolutePath());
                    uninstalledWithoutErrors = false;
                    if (postponedTasks != null) {
                        postponedTasks.addDeleteFileTask(file.toPath());
                    }
                }
                callback.fileRemoved();
                if (parent.isDirectory() && parent.list().length == 0) {
                    LOGGER.debug("Deleting: {}", (Object)parent.getAbsolutePath());
                    if (!parent.delete()) {
                        LOGGER.debug("Failed to delete: {}", (Object)parent.getAbsolutePath());
                    }
                }
                AddOnInstaller.deleteEmptyDirsCreatedForAddOnFiles(file);
            }
            catch (Exception e) {
                LOGGER.error("Failed to uninstall file {}", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        Control.getSingleton().getExtensionLoader().addonFilesRemoved();
        return uninstalledWithoutErrors;
    }

    private static List<String> getFilesSafeForUninstall(AddOn addOn, Set<AddOn> installedAddOns) {
        if (addOn.getFiles() == null || addOn.getFiles().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> files = new ArrayList<String>(addOn.getFiles());
        installedAddOns.forEach(installedAddOn -> {
            if (installedAddOn == addOn) {
                return;
            }
            List<String> addOnFiles = installedAddOn.getFiles();
            if (addOnFiles == null || addOnFiles.isEmpty()) {
                return;
            }
            files.removeAll(addOnFiles);
        });
        return files;
    }

    private static void deleteEmptyDirsCreatedForAddOnFiles(File file) {
        File currentFile;
        if (file == null) {
            return;
        }
        for (currentFile = file; currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
        }
        String root = new File(Constant.getZapHome()).getAbsolutePath();
        while (currentFile != null && currentFile.exists() && currentFile.getAbsolutePath().startsWith(root) && currentFile.getAbsolutePath().length() > root.length()) {
            AddOnInstaller.deleteEmptyDirs(currentFile);
            currentFile = currentFile.getParentFile();
        }
    }

    private static void deleteEmptyDirs(File dir) {
        LOGGER.debug("Deleting dir {}", (Object)dir.getAbsolutePath());
        for (File d : dir.listFiles()) {
            if (!d.isDirectory()) continue;
            AddOnInstaller.deleteEmptyDirs(d);
        }
        if (!dir.delete()) {
            LOGGER.debug("Failed to delete: {}", (Object)dir.getAbsolutePath());
        }
    }
}

