/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import jakarta.websocket.DeploymentException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.util.res.StringManager;

public class UriTemplate {
    private static final StringManager sm = StringManager.getManager(UriTemplate.class);
    private final String normalized;
    private final List<Segment> segments = new ArrayList<Segment>();
    private final boolean hasParameters;

    public UriTemplate(String string) throws DeploymentException {
        if (string == null || !string.startsWith("/") || string.contains("/../") || string.contains("/./") || string.contains("//")) {
            throw new DeploymentException(sm.getString("uriTemplate.invalidPath", new Object[]{string}));
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = string.split("/", -1);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.isEmpty()) {
                if (i == 0 || i == stringArray.length - 1 && n == 0) continue;
                throw new DeploymentException(sm.getString("uriTemplate.emptySegment", new Object[]{string}));
            }
            stringBuilder.append('/');
            int n3 = -1;
            if (string2.startsWith("{") && string2.endsWith("}")) {
                n3 = n2;
                string2 = string2.substring(1, string2.length() - 1);
                stringBuilder.append('{');
                stringBuilder.append(n++);
                stringBuilder.append('}');
                if (!hashSet.add(string2)) {
                    throw new DeploymentException(sm.getString("uriTemplate.duplicateParameter", new Object[]{string2}));
                }
            } else {
                if (string2.contains("{") || string2.contains("}")) {
                    throw new DeploymentException(sm.getString("uriTemplate.invalidSegment", new Object[]{string2, string}));
                }
                stringBuilder.append(string2);
            }
            this.segments.add(new Segment(n3, string2));
            ++n2;
        }
        this.normalized = stringBuilder.toString();
        this.hasParameters = n > 0;
    }

    public Map<String, String> match(UriTemplate uriTemplate) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (uriTemplate.getSegmentCount() != this.getSegmentCount()) {
            return null;
        }
        Iterator<Segment> iterator = this.segments.iterator();
        for (Segment segment : uriTemplate.getSegments()) {
            Segment segment2 = iterator.next();
            if (segment2.getParameterIndex() == -1) {
                if (segment2.getValue().equals(segment.getValue())) continue;
                return null;
            }
            hashMap.put(segment2.getValue(), segment.getValue());
        }
        return hashMap;
    }

    public boolean hasParameters() {
        return this.hasParameters;
    }

    public int getSegmentCount() {
        return this.segments.size();
    }

    public String getNormalizedPath() {
        return this.normalized;
    }

    private List<Segment> getSegments() {
        return this.segments;
    }

    private static class Segment {
        private final int parameterIndex;
        private final String value;

        Segment(int n, String string) {
            this.parameterIndex = n;
            this.value = string;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public String getValue() {
            return this.value;
        }
    }
}

