/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.HashSink;
import java.util.Map;

@FunctionalInterface
public interface HashFunnel<T> {
    public void put(T var1, HashSink var2);

    public static HashFunnel<String> forString() {
        return (s, sink) -> sink.putString((String)s);
    }

    public static <K, V> HashFunnel<Map.Entry<K, V>> forEntry(HashFunnel<K> keyHashFunnel, HashFunnel<V> valueHashFunnel) {
        return (entry, sink) -> {
            sink.put(entry.getKey(), keyHashFunnel);
            sink.put(entry.getValue(), valueHashFunnel);
        };
    }
}

