/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class LevelHeightProcessor
implements ILayoutProcessor<TGraph> {
    private int numberOfNodes;

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor determine the height for each level", 1.0f);
        this.numberOfNodes = tGraph.getNodes().isEmpty() ? 1 : tGraph.getNodes().size();
        TNode root = null;
        Iterator<TNode> it = tGraph.getNodes().iterator();
        while (root == null && it.hasNext()) {
            TNode tNode = it.next();
            if (!tNode.getProperty(InternalProperties.ROOT).booleanValue()) continue;
            root = tNode;
        }
        if (root != null) {
            this.setNeighbors(Lists.newArrayList(root), progressMonitor, tGraph.getProperty(MrTreeOptions.DIRECTION));
        }
        progressMonitor.done();
    }

    private void setNeighbors(Iterable<TNode> currentLevel, IElkProgressMonitor progressMonitor, Direction layoutDirection) {
        if (!Iterables.isEmpty(currentLevel)) {
            IElkProgressMonitor sT = progressMonitor.subTask(Iterables.size(currentLevel) / this.numberOfNodes);
            sT.begin("Set neighbors in level", 1.0f);
            Iterable<TNode> nextLevel = new Iterable<TNode>(){

                @Override
                public Iterator<TNode> iterator() {
                    return Collections.emptyIterator();
                }
            };
            double height = 0.0;
            if (layoutDirection.isHorizontal()) {
                for (TNode cN : currentLevel) {
                    nextLevel = Iterables.concat(nextLevel, cN.getChildren());
                    if (!(height < cN.getSize().x)) continue;
                    height = cN.getSize().x;
                }
            } else {
                for (TNode cN : currentLevel) {
                    nextLevel = Iterables.concat(nextLevel, cN.getChildren());
                    if (!(height < cN.getSize().y)) continue;
                    height = cN.getSize().y;
                }
            }
            for (TNode cN : currentLevel) {
                cN.setProperty(InternalProperties.LEVELHEIGHT, (Object)height);
            }
            sT.done();
            this.setNeighbors(nextLevel, progressMonitor, layoutDirection);
        }
    }
}

