/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.MatchBehavior;
import org.passay.PasswordData;
import org.passay.PasswordUtils;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultMetadata;

public class WhitespaceRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_WHITESPACE";
    protected static final char[] CHARS = new char[]{'\t', '\n', '\u000b', '\f', '\r', ' '};
    protected boolean reportAllFailures;
    private final char[] whitespaceCharacters;
    private final MatchBehavior matchBehavior;

    public WhitespaceRule() {
        this(CHARS, MatchBehavior.Contains, true);
    }

    public WhitespaceRule(MatchBehavior behavior) {
        this(CHARS, behavior, true);
    }

    public WhitespaceRule(char[] chars) {
        this(chars, MatchBehavior.Contains, true);
    }

    public WhitespaceRule(MatchBehavior behavior, boolean reportAll) {
        this(CHARS, behavior, reportAll);
    }

    public WhitespaceRule(char[] chars, MatchBehavior behavior) {
        this(chars, behavior, true);
    }

    public WhitespaceRule(char[] chars, boolean reportAll) {
        this(chars, MatchBehavior.Contains, reportAll);
    }

    public WhitespaceRule(char[] chars, MatchBehavior behavior, boolean reportAll) {
        for (char c : chars) {
            if (Character.isWhitespace(c)) continue;
            throw new IllegalArgumentException("Character '" + c + "' is not whitespace");
        }
        this.whitespaceCharacters = chars;
        this.matchBehavior = behavior;
        this.reportAllFailures = reportAll;
    }

    public char[] getWhitespaceCharacters() {
        return this.whitespaceCharacters;
    }

    public MatchBehavior getMatchBehavior() {
        return this.matchBehavior;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        String text = passwordData.getPassword();
        for (char c : this.whitespaceCharacters) {
            if (!this.matchBehavior.match(text, c)) continue;
            String[] codes = new String[]{"ILLEGAL_WHITESPACE." + this.matchBehavior.upperSnakeName(), ERROR_CODE};
            result.addError(codes, this.createRuleResultDetailParameters(c));
            if (!this.reportAllFailures) break;
        }
        result.setMetadata(this.createRuleResultMetadata(passwordData));
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(char c) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("whitespaceCharacter", Character.valueOf(c));
        m.put("matchBehavior", (Object)this.matchBehavior);
        return m;
    }

    protected RuleResultMetadata createRuleResultMetadata(PasswordData password) {
        return new RuleResultMetadata(RuleResultMetadata.CountCategory.Whitespace, PasswordUtils.countMatchingCharacters(String.valueOf(this.whitespaceCharacters), password.getPassword()));
    }

    public String toString() {
        return String.format("%s@%h::reportAllFailures=%s,matchBehavior=%s,whitespaceCharacters=%s", new Object[]{this.getClass().getName(), this.hashCode(), this.reportAllFailures, this.matchBehavior, Arrays.toString(this.whitespaceCharacters)});
    }
}

