/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.signer.SignerClient;
import software.amazon.awssdk.services.signer.internal.UserAgentUtils;
import software.amazon.awssdk.services.signer.model.ListSigningProfilesRequest;
import software.amazon.awssdk.services.signer.model.ListSigningProfilesResponse;

public class ListSigningProfilesIterable
implements SdkIterable<ListSigningProfilesResponse> {
    private final SignerClient client;
    private final ListSigningProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSigningProfilesIterable(SignerClient client, ListSigningProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSigningProfilesResponseFetcher();
    }

    public Iterator<ListSigningProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSigningProfilesResponseFetcher
    implements SyncPageFetcher<ListSigningProfilesResponse> {
        private ListSigningProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListSigningProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSigningProfilesResponse nextPage(ListSigningProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListSigningProfilesIterable.this.client.listSigningProfiles(ListSigningProfilesIterable.this.firstRequest);
            }
            return ListSigningProfilesIterable.this.client.listSigningProfiles((ListSigningProfilesRequest)((Object)ListSigningProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

