/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.nativeindex;

import java.io.IOException;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.lucene.index.FieldInfo;
import org.opensearch.index.IndexSettings;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.codec.nativeindex.DefaultIndexBuildStrategy;
import org.opensearch.knn.index.codec.nativeindex.MemOptimizedNativeIndexBuildStrategy;
import org.opensearch.knn.index.codec.nativeindex.NativeIndexBuildStrategy;
import org.opensearch.knn.index.codec.nativeindex.model.BuildIndexParams;
import org.opensearch.knn.index.codec.nativeindex.remote.RemoteIndexBuildStrategy;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.repositories.RepositoriesService;

public final class NativeIndexBuildStrategyFactory {
    private final Supplier<RepositoriesService> repositoriesServiceSupplier;
    private final IndexSettings indexSettings;
    private KNNLibraryIndexingContext knnLibraryIndexingContext;

    public NativeIndexBuildStrategyFactory() {
        this(null, null);
    }

    public NativeIndexBuildStrategyFactory(Supplier<RepositoriesService> repositoriesServiceSupplier, IndexSettings indexSettings) {
        this.repositoriesServiceSupplier = repositoriesServiceSupplier;
        this.indexSettings = indexSettings;
    }

    public NativeIndexBuildStrategy getBuildStrategy(FieldInfo fieldInfo, int totalLiveDocs, KNNVectorValues<?> knnVectorValues, BuildIndexParams indexInfo) throws IOException {
        KNNEngine knnEngine = FieldInfoExtractor.extractKNNEngine(fieldInfo);
        boolean isTemplate = fieldInfo.attributes().containsKey("model_id");
        boolean iterative = !isTemplate && KNNEngine.FAISS == knnEngine;
        NativeIndexBuildStrategy strategy = iterative ? MemOptimizedNativeIndexBuildStrategy.getInstance() : DefaultIndexBuildStrategy.getInstance();
        KNNCodecUtil.initializeVectorValues(knnVectorValues);
        long vectorBlobLength = (long)knnVectorValues.bytesPerVector() * (long)totalLiveDocs;
        if (KNNSettings.isKNNRemoteVectorBuildEnabled() && this.repositoriesServiceSupplier != null && this.indexSettings != null && knnEngine.supportsRemoteIndexBuild(this.knnLibraryIndexingContext) && RemoteIndexBuildStrategy.shouldBuildIndexRemotely(this.indexSettings, vectorBlobLength)) {
            return new RemoteIndexBuildStrategy(this.repositoriesServiceSupplier, strategy, this.indexSettings, this.knnLibraryIndexingContext);
        }
        return strategy;
    }

    @Generated
    public void setKnnLibraryIndexingContext(KNNLibraryIndexingContext knnLibraryIndexingContext) {
        this.knnLibraryIndexingContext = knnLibraryIndexingContext;
    }
}

