/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.internals.metrics.OpenIterators;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.KeyQuery;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.RangeQuery;
import org.apache.kafka.streams.query.ResultOrder;
import org.apache.kafka.streams.query.internals.InternalQueryResultUtil;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredIterator;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.apache.kafka.streams.state.internals.StoreSerdeInitializer;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;

public class MeteredKeyValueStore<K, V>
extends WrappedStateStore<KeyValueStore<Bytes, byte[]>, K, V>
implements KeyValueStore<K, V> {
    final Serde<K> keySerde;
    final Serde<V> valueSerde;
    StateSerdes<K, V> serdes;
    private final String metricsScope;
    protected final Time time;
    protected Sensor putSensor;
    private Sensor putIfAbsentSensor;
    protected Sensor getSensor;
    protected Sensor deleteSensor;
    private Sensor putAllSensor;
    private Sensor allSensor;
    private Sensor rangeSensor;
    private Sensor prefixScanSensor;
    private Sensor flushSensor;
    private Sensor e2eLatencySensor;
    protected Sensor iteratorDurationSensor;
    protected InternalProcessorContext<?, ?> internalContext;
    private StreamsMetricsImpl streamsMetrics;
    private TaskId taskId;
    protected OpenIterators openIterators;
    private final Map<Class, StoreQueryUtils.QueryHandler> queryHandlers = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry(RangeQuery.class, (query, positionBound, config, store) -> this.runRangeQuery(query, positionBound, config)), Utils.mkEntry(KeyQuery.class, (query, positionBound, config, store) -> this.runKeyQuery(query, positionBound, config))});

    MeteredKeyValueStore(KeyValueStore<Bytes, byte[]> inner, String metricsScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.metricsScope = metricsScope;
        this.time = time != null ? time : Time.SYSTEM;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    public void init(StateStoreContext stateStoreContext, StateStore root) {
        this.internalContext = stateStoreContext instanceof InternalProcessorContext ? (InternalProcessorContext)stateStoreContext : null;
        this.taskId = stateStoreContext.taskId();
        this.initStoreSerde(stateStoreContext);
        this.streamsMetrics = (StreamsMetricsImpl)stateStoreContext.metrics();
        this.registerMetrics();
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(stateStoreContext, root), this.time, restoreSensor);
    }

    private void registerMetrics() {
        this.putSensor = StateStoreMetrics.putSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.putIfAbsentSensor = StateStoreMetrics.putIfAbsentSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.putAllSensor = StateStoreMetrics.putAllSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.getSensor = StateStoreMetrics.getSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.allSensor = StateStoreMetrics.allSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.rangeSensor = StateStoreMetrics.rangeSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.prefixScanSensor = StateStoreMetrics.prefixScanSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.flushSensor = StateStoreMetrics.flushSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.deleteSensor = StateStoreMetrics.deleteSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.e2eLatencySensor = StateStoreMetrics.e2ELatencySensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        this.iteratorDurationSensor = StateStoreMetrics.iteratorDurationSensor(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics);
        StateStoreMetrics.addNumOpenIteratorsGauge(this.taskId.toString(), this.metricsScope, this.name(), this.streamsMetrics, (Gauge<Long>)((Gauge)(config, now) -> this.openIterators.sum()));
        this.openIterators = new OpenIterators(this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
    }

    protected Serde<V> prepareValueSerdeForStore(Serde<V> valueSerde, SerdeGetter getter) {
        return WrappingNullableUtils.prepareValueSerde(valueSerde, getter);
    }

    protected void initStoreSerde(StateStoreContext context) {
        String storeName = this.name();
        String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName, Boolean.FALSE);
        this.serdes = StoreSerdeInitializer.prepareStoreSerde(context, storeName, changelogTopic, this.keySerde, this.valueSerde, this::prepareValueSerdeForStore);
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<K, V> listener, boolean sendOldValues) {
        KeyValueStore wrapped = (KeyValueStore)this.wrapped();
        if (wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)((Object)wrapped)).setFlushListener(record -> listener.apply(record.withKey(this.serdes.keyFrom((byte[])record.key())).withValue(new Change<Object>((((Change)record.value()).newValue != null ? (Object)this.serdes.valueFrom((byte[])((Change)record.value()).newValue) : null), (((Change)record.value()).oldValue != null ? (Object)this.serdes.valueFrom((byte[])((Change)record.value()).oldValue) : null), ((Change)record.value()).isLatest))), sendOldValues);
        }
        return false;
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        long start = this.time.nanoseconds();
        StoreQueryUtils.QueryHandler handler = this.queryHandlers.get(query.getClass());
        if (handler == null) {
            result = ((KeyValueStore)this.wrapped()).query(query, positionBound, config);
            if (config.isCollectExecutionInfo()) {
                result.addExecutionInfo("Handled in " + String.valueOf(this.getClass()) + " in " + (this.time.nanoseconds() - start) + "ns");
            }
        } else {
            result = handler.apply(query, positionBound, config, this);
            if (config.isCollectExecutionInfo()) {
                result.addExecutionInfo("Handled in " + String.valueOf(this.getClass()) + " with serdes " + String.valueOf(this.serdes) + " in " + (this.time.nanoseconds() - start) + "ns");
            }
        }
        return result;
    }

    @Override
    public Position getPosition() {
        return ((KeyValueStore)this.wrapped()).getPosition();
    }

    private <R> QueryResult<R> runRangeQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        QueryResult rawResult;
        RangeQuery typedQuery = (RangeQuery)query;
        ResultOrder order = typedQuery.resultOrder();
        RangeQuery rawRangeQuery = RangeQuery.withRange(this.keyBytes(typedQuery.getLowerBound().orElse(null)), this.keyBytes(typedQuery.getUpperBound().orElse(null)));
        if (order.equals((Object)ResultOrder.DESCENDING)) {
            rawRangeQuery = rawRangeQuery.withDescendingKeys();
        }
        if (order.equals((Object)ResultOrder.ASCENDING)) {
            rawRangeQuery = rawRangeQuery.withAscendingKeys();
        }
        if ((rawResult = ((KeyValueStore)this.wrapped()).query(rawRangeQuery, positionBound, config)).isSuccess()) {
            KeyValueIterator iterator = (KeyValueIterator)rawResult.getResult();
            MeteredKeyValueTimestampedIterator resultIterator = new MeteredKeyValueTimestampedIterator(iterator, this.getSensor, StoreQueryUtils.deserializeValue(this.serdes, this.wrapped()));
            QueryResult<MeteredKeyValueTimestampedIterator> typedQueryResult = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(rawResult, resultIterator);
            result = typedQueryResult;
        } else {
            result = rawResult;
        }
        return result;
    }

    private <R> QueryResult<R> runKeyQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        KeyQuery typedKeyQuery = (KeyQuery)query;
        KeyQuery rawKeyQuery = KeyQuery.withKey(this.keyBytes(typedKeyQuery.getKey()));
        QueryResult rawResult = ((KeyValueStore)this.wrapped()).query(rawKeyQuery, positionBound, config);
        if (rawResult.isSuccess()) {
            Function<byte[], V> deserializer = StoreQueryUtils.deserializeValue(this.serdes, this.wrapped());
            V value = deserializer.apply((byte[])rawResult.getResult());
            QueryResult<V> typedQueryResult = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(rawResult, value);
            result = typedQueryResult;
        } else {
            result = rawResult;
        }
        return result;
    }

    @Override
    public V get(K key) {
        Objects.requireNonNull(key, "key cannot be null");
        try {
            return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> this.outerValue((byte[])((KeyValueStore)this.wrapped()).get(this.keyBytes(key))), this.time, this.getSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public void put(K key, V value) {
        Objects.requireNonNull(key, "key cannot be null");
        try {
            StreamsMetricsImpl.maybeMeasureLatency(() -> ((KeyValueStore)this.wrapped()).put(this.keyBytes(key), this.serdes.rawValue(value)), this.time, this.putSensor);
            this.maybeRecordE2ELatency();
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, value);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Objects.requireNonNull(key, "key cannot be null");
        Object currentValue = StreamsMetricsImpl.maybeMeasureLatency(() -> this.outerValue(((KeyValueStore)this.wrapped()).putIfAbsent(this.keyBytes(key), this.serdes.rawValue(value))), this.time, this.putIfAbsentSensor);
        this.maybeRecordE2ELatency();
        return (V)currentValue;
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        entries.forEach(entry -> Objects.requireNonNull(entry.key, "key cannot be null"));
        StreamsMetricsImpl.maybeMeasureLatency(() -> ((KeyValueStore)this.wrapped()).putAll(this.innerEntries(entries)), this.time, this.putAllSensor);
    }

    @Override
    public V delete(K key) {
        Objects.requireNonNull(key, "key cannot be null");
        try {
            return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> this.outerValue((byte[])((KeyValueStore)this.wrapped()).delete(this.keyBytes(key))), this.time, this.deleteSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<K, V> prefixScan(P prefix, PS prefixKeySerializer) {
        Objects.requireNonNull(prefix, "prefix cannot be null");
        Objects.requireNonNull(prefixKeySerializer, "prefixKeySerializer cannot be null");
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).prefixScan(prefix, prefixKeySerializer), this.prefixScanSensor);
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        byte[] serFrom = from == null ? null : this.serdes.rawKey(from);
        byte[] serTo = to == null ? null : this.serdes.rawKey(to);
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).range(Bytes.wrap((byte[])serFrom), Bytes.wrap((byte[])serTo)), this.rangeSensor);
    }

    @Override
    public KeyValueIterator<K, V> reverseRange(K from, K to) {
        byte[] serFrom = from == null ? null : this.serdes.rawKey(from);
        byte[] serTo = to == null ? null : this.serdes.rawKey(to);
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).reverseRange(Bytes.wrap((byte[])serFrom), Bytes.wrap((byte[])serTo)), this.rangeSensor);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).all(), this.allSensor);
    }

    @Override
    public KeyValueIterator<K, V> reverseAll() {
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).reverseAll(), this.allSensor);
    }

    @Override
    public void flush() {
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.flush(), this.time, this.flushSensor);
    }

    @Override
    public long approximateNumEntries() {
        return ((KeyValueStore)this.wrapped()).approximateNumEntries();
    }

    @Override
    public void close() {
        try {
            ((KeyValueStore)this.wrapped()).close();
        }
        finally {
            this.streamsMetrics.removeAllStoreLevelSensorsAndMetrics(this.taskId.toString(), this.name());
        }
    }

    protected V outerValue(byte[] value) {
        return value != null ? (V)this.serdes.valueFrom(value) : null;
    }

    protected Bytes keyBytes(K key) {
        return Bytes.wrap((byte[])this.serdes.rawKey(key));
    }

    private List<KeyValue<Bytes, byte[]>> innerEntries(List<KeyValue<K, V>> from) {
        ArrayList<KeyValue<Bytes, byte[]>> byteEntries = new ArrayList<KeyValue<Bytes, byte[]>>();
        for (KeyValue<K, V> entry : from) {
            byteEntries.add(KeyValue.pair(Bytes.wrap((byte[])this.serdes.rawKey(entry.key)), this.serdes.rawValue(entry.value)));
        }
        return byteEntries;
    }

    protected void maybeRecordE2ELatency() {
        if (this.e2eLatencySensor.shouldRecord() && this.internalContext != null) {
            long currentTime = this.time.milliseconds();
            long e2eLatency = currentTime - this.internalContext.timestamp();
            this.e2eLatencySensor.record((double)e2eLatency, currentTime);
        }
    }

    private class MeteredKeyValueTimestampedIterator
    implements KeyValueIterator<K, V>,
    MeteredIterator {
        private final KeyValueIterator<Bytes, byte[]> iter;
        private final Sensor sensor;
        private final long startNs;
        private final long startTimestamp;
        private final Function<byte[], V> valueDeserializer;

        private MeteredKeyValueTimestampedIterator(KeyValueIterator<Bytes, byte[]> iter, Sensor sensor, Function<byte[], V> valueDeserializer) {
            this.iter = iter;
            this.sensor = sensor;
            this.valueDeserializer = valueDeserializer;
            this.startTimestamp = MeteredKeyValueStore.this.time.milliseconds();
            this.startNs = MeteredKeyValueStore.this.time.nanoseconds();
            MeteredKeyValueStore.this.openIterators.add(this);
        }

        @Override
        public long startTimestamp() {
            return this.startTimestamp;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            KeyValue keyValue = (KeyValue)this.iter.next();
            return KeyValue.pair(MeteredKeyValueStore.this.serdes.keyFrom(((Bytes)keyValue.key).get()), this.valueDeserializer.apply((byte[])keyValue.value));
        }

        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                long duration = MeteredKeyValueStore.this.time.nanoseconds() - this.startNs;
                this.sensor.record((double)duration);
                MeteredKeyValueStore.this.iteratorDurationSensor.record((double)duration);
                MeteredKeyValueStore.this.openIterators.remove(this);
            }
        }

        @Override
        public K peekNextKey() {
            return MeteredKeyValueStore.this.serdes.keyFrom(this.iter.peekNextKey().get());
        }
    }

    private class MeteredKeyValueIterator
    implements KeyValueIterator<K, V>,
    MeteredIterator {
        private final KeyValueIterator<Bytes, byte[]> iter;
        private final Sensor sensor;
        private final long startNs;
        private final long startTimestamp;

        private MeteredKeyValueIterator(KeyValueIterator<Bytes, byte[]> iter, Sensor sensor) {
            this.iter = iter;
            this.sensor = sensor;
            this.startTimestamp = MeteredKeyValueStore.this.time.milliseconds();
            this.startNs = MeteredKeyValueStore.this.time.nanoseconds();
            MeteredKeyValueStore.this.openIterators.add(this);
        }

        @Override
        public long startTimestamp() {
            return this.startTimestamp;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            KeyValue keyValue = (KeyValue)this.iter.next();
            return KeyValue.pair(MeteredKeyValueStore.this.serdes.keyFrom(((Bytes)keyValue.key).get()), MeteredKeyValueStore.this.outerValue((byte[])keyValue.value));
        }

        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                long duration = MeteredKeyValueStore.this.time.nanoseconds() - this.startNs;
                this.sensor.record((double)duration);
                MeteredKeyValueStore.this.iteratorDurationSensor.record((double)duration);
                MeteredKeyValueStore.this.openIterators.remove(this);
            }
        }

        @Override
        public K peekNextKey() {
            return MeteredKeyValueStore.this.serdes.keyFrom(this.iter.peekNextKey().get());
        }
    }
}

