/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import ghidra.util.exception.NoValueException;
import ghidra.util.graph.DirectedGraph;
import ghidra.util.graph.Edge;
import ghidra.util.graph.GraphIterator;
import ghidra.util.graph.Vertex;
import ghidra.util.graph.attributes.DoubleAttribute;

@Deprecated(forRemoval=true, since="10.2")
public class WeightedDigraph
extends DirectedGraph {
    private double defaultValue = 1.0;

    public WeightedDigraph(int vertexCapacity, int edgeCapacity) {
        super(vertexCapacity, edgeCapacity);
        this.edgeAttributes().createAttribute("weight", "DOUBLE_TYPE");
    }

    private DoubleAttribute<Edge> weights() {
        return (DoubleAttribute)this.edgeAttributes().getAttribute("weight");
    }

    public WeightedDigraph(int vertexCapacity, int edgeCapacity, double defaultEdgeWeight) {
        super(vertexCapacity, edgeCapacity);
        this.defaultValue = defaultEdgeWeight;
        this.edgeAttributes().createAttribute("weight", "DOUBLE_TYPE");
    }

    public WeightedDigraph() {
        this(101, 101);
    }

    @Override
    public double inDegree(Vertex v) {
        double degree = 0.0;
        Edge[] edges = this.incomingEdges(v);
        int length = edges.length;
        for (int i = 0; i < length; ++i) {
            try {
                degree += this.weights().getValue(edges[i]);
                continue;
            }
            catch (NoValueException exc) {
                degree += this.defaultValue;
            }
        }
        return degree;
    }

    @Override
    public double outDegree(Vertex v) {
        double degree = 0.0;
        Edge[] edges = this.outgoingEdges(v);
        int length = edges.length;
        for (int i = 0; i < length; ++i) {
            try {
                degree += this.weights().getValue(edges[i]);
                continue;
            }
            catch (NoValueException exc) {
                degree += this.defaultValue;
            }
        }
        return degree;
    }

    public double selfDegree(Vertex v) {
        double degree = 0.0;
        Edge[] edges = this.selfEdges(v);
        int length = edges.length;
        for (int i = 0; i < length; ++i) {
            try {
                degree += this.weights().getValue(edges[i]);
                continue;
            }
            catch (NoValueException exc) {
                degree += 0.0;
            }
        }
        return degree;
    }

    @Override
    public double degree(Vertex v) {
        return this.inDegree(v) + this.outDegree(v) - this.selfDegree(v);
    }

    public double getWeight(Edge e) {
        try {
            return this.weights().getValue(e);
        }
        catch (NoValueException ex) {
            return 0.0;
        }
    }

    public boolean setWeight(Edge e, double value) {
        return this.weights().setValue(e, value);
    }

    public double getDefaultEdgeWeight() {
        return this.defaultValue;
    }

    @Override
    public boolean add(Edge e) {
        double wt = this.getWeight(e);
        boolean returnValue = super.add(e);
        if (returnValue) {
            this.setWeight(e, this.defaultValue);
        } else {
            this.setWeight(e, wt + this.defaultValue);
        }
        return true;
    }

    public boolean add(Edge e, double weight) {
        double wt = this.getWeight(e);
        super.add(e);
        this.setWeight(e, wt + weight);
        return true;
    }

    public DoubleAttribute<Edge> getEdgeWeights() {
        return this.weights();
    }

    @Override
    public DirectedGraph copy() {
        WeightedDigraph copy = new WeightedDigraph(this.numVertices(), this.numEdges(), this.getDefaultEdgeWeight());
        this.copyAll(copy);
        return copy;
    }

    @Override
    public void intersectionWith(DirectedGraph otherGraph) {
        GraphIterator<Vertex> vi = otherGraph.vertexIterator();
        while (vi.hasNext()) {
            Vertex v = vi.next();
            if (this.contains(v)) continue;
            vi.remove();
        }
        GraphIterator<Edge> ei = otherGraph.edgeIterator();
        while (ei.hasNext()) {
            Edge e = ei.next();
            if (this.contains(e)) continue;
            ei.remove();
        }
    }

    @Override
    public void unionWith(DirectedGraph otherGraph) {
        DoubleAttribute otherWts = (DoubleAttribute)otherGraph.edgeAttributes().getAttribute("weight");
        GraphIterator<Vertex> vi = otherGraph.vertexIterator();
        while (vi.hasNext()) {
            this.add(vi.next());
        }
        GraphIterator<Edge> ei = otherGraph.edgeIterator();
        while (ei.hasNext()) {
            Edge e = ei.next();
            try {
                this.add(e, otherWts.getValue(e));
            }
            catch (NoValueException e1) {
                this.add(e);
            }
        }
    }
}

