/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class PivotingImageShaper {
    static int sample = 1;
    static int firstx = 0;

    public static Shape getShape(BufferedImage image) {
        firstx = 0;
        return PivotingImageShaper.leftEdge(image, new GeneralPath());
    }

    private static Point2D detectLine(Point2D p1, Point2D p2, Point2D p, Line2D line, GeneralPath path) {
        if (p2 == null) {
            p2 = p;
            line.setLine(p1, p2);
        } else if (line.ptLineDistSq(p) < 1.0) {
            p2.setLocation(p);
        } else {
            p1.setLocation(p2);
            p2.setLocation(p);
            line.setLine(p1, p2);
            path.lineTo((float)p1.getX(), (float)p1.getY());
        }
        return p2;
    }

    private static Shape leftEdge(BufferedImage image, GeneralPath path) {
        int lastj = 0;
        Point2D.Float p1 = null;
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        for (int i = 0; i < image.getHeight(); i += sample) {
            boolean aPointExistsOnThisLine = false;
            for (int j = 0; j < image.getWidth(); j += sample) {
                if ((image.getRGB(j, i) & 0xFF000000) == 0) continue;
                Point2D.Float p = new Point2D.Float(j, i);
                aPointExistsOnThisLine = true;
                if (path.getCurrentPoint() != null) {
                    p2 = PivotingImageShaper.detectLine(p1, p2, p, line, path);
                } else {
                    path.moveTo(j, i);
                    firstx = j;
                    p1 = p;
                }
                lastj = j;
                break;
            }
            if (!aPointExistsOnThisLine) break;
        }
        return PivotingImageShaper.bottomEdge(image, path, lastj);
    }

    private static Shape bottomEdge(BufferedImage image, GeneralPath path, int start) {
        int lastj = 0;
        Point2D p1 = path.getCurrentPoint();
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        for (int i = start; i < image.getWidth(); i += sample) {
            boolean aPointExistsOnThisLine = false;
            for (int j = image.getHeight() - 1; j >= 0; j -= sample) {
                if ((image.getRGB(i, j) & 0xFF000000) == 0) continue;
                Point2D.Float p = new Point2D.Float(i, j);
                aPointExistsOnThisLine = true;
                p2 = PivotingImageShaper.detectLine(p1, p2, p, line, path);
                lastj = j;
                break;
            }
            if (!aPointExistsOnThisLine) break;
        }
        return PivotingImageShaper.rightEdge(image, path, lastj);
    }

    private static Shape rightEdge(BufferedImage image, GeneralPath path, int start) {
        int lastj = 0;
        Point2D p1 = path.getCurrentPoint();
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        for (int i = start; i >= 0; i -= sample) {
            boolean aPointExistsOnThisLine = false;
            for (int j = image.getWidth() - 1; j >= 0; j -= sample) {
                if ((image.getRGB(j, i) & 0xFF000000) == 0) continue;
                Point2D.Float p = new Point2D.Float(j, i);
                aPointExistsOnThisLine = true;
                p2 = PivotingImageShaper.detectLine(p1, p2, p, line, path);
                lastj = j;
                break;
            }
            if (!aPointExistsOnThisLine) break;
        }
        return PivotingImageShaper.topEdge(image, path, lastj);
    }

    private static Shape topEdge(BufferedImage image, GeneralPath path, int start) {
        Point2D p1 = path.getCurrentPoint();
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        for (int i = start; i >= firstx; i -= sample) {
            boolean aPointExistsOnThisLine = false;
            for (int j = 0; j < image.getHeight(); j += sample) {
                if ((image.getRGB(i, j) & 0xFF000000) == 0) continue;
                Point2D.Float p = new Point2D.Float(i, j);
                aPointExistsOnThisLine = true;
                p2 = PivotingImageShaper.detectLine(p1, p2, p, line, path);
                break;
            }
            if (!aPointExistsOnThisLine) break;
        }
        path.closePath();
        return path;
    }
}

