/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.rect;

import ghidra.util.database.spatial.BoundingShape;
import ghidra.util.database.spatial.rect.EuclideanSpace2D;
import ghidra.util.database.spatial.rect.ImmutablePoint2D;
import ghidra.util.database.spatial.rect.Point2D;
import java.util.NoSuchElementException;
import java.util.Objects;

public interface Rectangle2D<X, Y, R extends Rectangle2D<X, Y, R>>
extends BoundingShape<R> {
    public static <X, Y> boolean encloses(Rectangle2D<X, Y, ?> outer, Rectangle2D<X, Y, ?> inner) {
        if (outer.getSpace().compareX(outer.getX1(), inner.getX1()) > 0) {
            return false;
        }
        if (outer.getSpace().compareX(outer.getX2(), inner.getX2()) < 0) {
            return false;
        }
        if (outer.getSpace().compareY(outer.getY1(), inner.getY1()) > 0) {
            return false;
        }
        return outer.getSpace().compareY(outer.getY2(), inner.getY2()) >= 0;
    }

    public X getX1();

    public X getX2();

    public Y getY1();

    public Y getY2();

    public EuclideanSpace2D<X, Y> getSpace();

    default public boolean doEquals(Object obj) {
        if (!(obj instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D that = (Rectangle2D)obj;
        if (!this.getX1().equals(that.getX1())) {
            return false;
        }
        if (!this.getX2().equals(that.getX2())) {
            return false;
        }
        if (!this.getY1().equals(that.getY1())) {
            return false;
        }
        return this.getY2().equals(that.getY2());
    }

    default public int doHashCode() {
        return Objects.hash(this.getX1(), this.getX2(), this.getY1(), this.getY2());
    }

    default public boolean contains(Point2D<X, Y> point) {
        return this.contains(point.getX(), point.getY());
    }

    default public boolean contains(X x, Y y) {
        if (this.getSpace().compareX(x, this.getX1()) < 0) {
            return false;
        }
        if (this.getSpace().compareX(x, this.getX2()) > 0) {
            return false;
        }
        if (this.getSpace().compareY(y, this.getY1()) < 0) {
            return false;
        }
        return this.getSpace().compareY(y, this.getY2()) <= 0;
    }

    @Override
    default public double getArea() {
        double width = this.getSpace().distX(this.getX2(), this.getX1()) + 1.0;
        double height = this.getSpace().distY(this.getY2(), this.getY1()) + 1.0;
        return width * height;
    }

    @Override
    default public double getMargin() {
        double width = this.getSpace().distX(this.getX2(), this.getX1()) + 1.0;
        double height = this.getSpace().distY(this.getY2(), this.getY1()) + 1.0;
        return width + height;
    }

    default public Point2D<X, Y> getCenter() {
        return new ImmutablePoint2D<X, Y>(this.getSpace().midX(this.getX1(), this.getX2()), this.getSpace().midY(this.getY1(), this.getY2()), this.getSpace());
    }

    @Override
    default public double computeAreaUnionBounds(R shape) {
        X unionX1 = this.getSpace().minX(this.getX1(), shape.getX1());
        X unionX2 = this.getSpace().maxX(this.getX2(), shape.getX2());
        Y unionY1 = this.getSpace().minY(this.getY1(), shape.getY1());
        Y unionY2 = this.getSpace().maxY(this.getY2(), shape.getY2());
        double width = this.getSpace().distX(unionX2, unionX1) + 1.0;
        double height = this.getSpace().distY(unionY2, unionY1) + 1.0;
        return width * height;
    }

    @Override
    default public double computeAreaIntersection(R shape) {
        X intX1 = this.getSpace().maxX(this.getX1(), shape.getX1());
        X intX2 = this.getSpace().minX(this.getX2(), shape.getX2());
        Y intY1 = this.getSpace().maxY(this.getY1(), shape.getY1());
        Y intY2 = this.getSpace().minY(this.getY2(), shape.getY2());
        if (this.getSpace().compareX(intX1, intX2) > 0 || this.getSpace().compareY(intY1, intY2) > 0) {
            return 0.0;
        }
        double width = this.getSpace().distX(intX2, intX1) + 1.0;
        double height = this.getSpace().distY(intY2, intY1) + 1.0;
        return width * height;
    }

    @Override
    default public double computeCentroidDistance(R shape) {
        return this.getCenter().computeDistance(shape.getCenter());
    }

    public R immutable(X var1, X var2, Y var3, Y var4);

    @Override
    default public R unionBounds(R shape) {
        X unionX1 = this.getSpace().minX(this.getX1(), shape.getX1());
        X unionX2 = this.getSpace().maxX(this.getX2(), shape.getX2());
        Y unionY1 = this.getSpace().minY(this.getY1(), shape.getY1());
        Y unionY2 = this.getSpace().maxY(this.getY2(), shape.getY2());
        return this.immutable(unionX1, unionX2, unionY1, unionY2);
    }

    default public boolean intersects(R shape) {
        if (this.getSpace().compareX(this.getX1(), shape.getX2()) > 0) {
            return false;
        }
        if (this.getSpace().compareX(this.getX2(), shape.getX1()) < 0) {
            return false;
        }
        if (this.getSpace().compareY(this.getY1(), shape.getY2()) > 0) {
            return false;
        }
        return this.getSpace().compareY(this.getY2(), shape.getY1()) >= 0;
    }

    default public R intersection(R shape) {
        X intX1 = this.getSpace().maxX(this.getX1(), shape.getX1());
        X intX2 = this.getSpace().minX(this.getX2(), shape.getX2());
        Y intY1 = this.getSpace().maxY(this.getY1(), shape.getY1());
        Y intY2 = this.getSpace().minY(this.getY2(), shape.getY2());
        if (this.getSpace().compareX(intX1, intX2) > 0 || this.getSpace().compareY(intY1, intY2) > 0) {
            throw new NoSuchElementException();
        }
        return this.immutable(intX1, intX2, intY1, intY2);
    }

    @Override
    default public boolean encloses(R shape) {
        return Rectangle2D.encloses(this, shape);
    }

    default public boolean enclosedBy(R shape) {
        return Rectangle2D.encloses(shape, this);
    }
}

