/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.viewer.field.ResourceFieldLocation;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeWithCharset;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.Equate;
import ghidra.program.util.EquateOperandFieldLocation;
import ghidra.program.util.FieldNameFieldLocation;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.NumericUtilities;
import ghidra.util.UniversalID;
import javax.swing.JComponent;

public class DataTypeListingHover
extends AbstractConfigurableHover
implements ListingHoverService {
    private static final String NAME = "Data Type Display";
    private static final String DESCRIPTION = "Toggle whether data type contents are displayed in a tooltip when the mouse hovers over a data type.";
    private static final int PRIORITY = 20;

    public DataTypeListingHover(PluginTool tool) {
        super(tool, 20);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getOptionsCategory() {
        return "Listing Popups";
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null) {
            return null;
        }
        DataType dt = null;
        Data dataInstance = null;
        Integer dataLen = null;
        boolean hasInvalidStorage = false;
        if (programLocation instanceof VariableLocation) {
            if (programLocation instanceof VariableCommentFieldLocation) {
                return null;
            }
            Variable var = ((VariableLocation)programLocation).getVariable();
            if (var != null) {
                dt = var.getDataType();
                hasInvalidStorage = !var.isValid();
            }
        } else if (programLocation instanceof MnemonicFieldLocation) {
            dataInstance = this.getDataForLocation(program, programLocation);
            if (dataInstance != null && (dt = dataInstance.getDataType()).getLength() < 0) {
                dataLen = dataInstance.getLength();
            }
        } else if (programLocation instanceof FunctionReturnTypeFieldLocation) {
            dt = this.getFunctionReturnDataType(program, programLocation.getAddress());
        }
        if (dt != null) {
            String toolTipText = ToolTipUtils.getToolTipText(dt);
            if (dataLen != null) {
                toolTipText = toolTipText.replace("Unsized", Integer.toString(dataLen));
            }
            if (dataInstance != null) {
                toolTipText = toolTipText.replace("</html>", this.getLocationSupplimentalToolTipText(dt, dataInstance) + "</html>");
            }
            Object warningMsg = "";
            if (hasInvalidStorage) {
                warningMsg = (String)warningMsg + "WARNING! Invalid Storage";
            }
            if (((String)warningMsg).length() != 0) {
                String errorText = "<html><center><font color=\"" + GThemeDefaults.Colors.Messages.ERROR.toHexString() + "\">" + (String)warningMsg + "!</font></center><BR>";
                toolTipText = toolTipText.replace("<html>", errorText);
            }
            return this.createTooltipComponent(toolTipText);
        }
        if (programLocation instanceof EquateOperandFieldLocation) {
            EquateOperandFieldLocation equateLocation = (EquateOperandFieldLocation)programLocation;
            return this.createEquateToolTipComponent(program, equateLocation.getEquate());
        }
        if (programLocation instanceof ResourceFieldLocation) {
            ResourceFieldLocation resourceLoc = (ResourceFieldLocation)programLocation;
            Data data = resourceLoc.getResourceData();
            dt = data.getDataType();
            return this.createTooltipComponent(dt.getRepresentation((MemBuffer)data, (Settings)data, data.getLength()));
        }
        if (programLocation instanceof FieldNameFieldLocation) {
            Data parent;
            FieldNameFieldLocation nameLoc = (FieldNameFieldLocation)programLocation;
            Data data = nameLoc.getDataComponent();
            Data data2 = parent = data == null ? null : data.getParent();
            if (parent == null) {
                return this.createTooltipComponent("Field Name: " + nameLoc.getFieldName());
            }
            StringBuilder sb = new StringBuilder("<html>");
            sb.append("<TABLE>");
            DataType parentType = parent.getDataType();
            sb.append(this.row("Parent: ", parentType.getDataTypePath()));
            int offset = (int)data.getAddress().subtract(parent.getAddress());
            sb.append(this.row("Offset: ", NumericUtilities.toHexString((long)offset)));
            sb.append(this.row("Field Name: ", nameLoc.getFieldName()));
            if (parentType instanceof Structure) {
                String comment;
                Structure pst = (Structure)parentType;
                DataTypeComponent dtc = pst.getComponentAt(offset);
                String string = comment = dtc == null ? null : dtc.getComment();
                if (comment != null) {
                    sb.append(this.row("Comment: ", comment));
                }
            }
            sb.append("</TABLE>");
            return this.createTooltipComponent(sb.toString());
        }
        return null;
    }

    private String row(Object ... cols) {
        StringBuilder sb = new StringBuilder("<TR>");
        for (Object col : cols) {
            String escaped = this.escapeHtml(col);
            sb.append("<TD>").append(escaped).append("</TD>");
        }
        sb.append("</TR>");
        return sb.toString();
    }

    private String escapeHtml(Object obj) {
        return obj == null ? "" : HTMLUtilities.friendlyEncodeHTML((String)obj.toString());
    }

    private String getLocationSupplimentalToolTipText(DataType dt, Data dataInstance) {
        Object result = "";
        if (dt instanceof DataTypeWithCharset) {
            String charset = ((DataTypeWithCharset)dt).getCharsetName((Settings)dataInstance);
            result = String.format("<br>Charset: %s", charset);
        }
        if (StringDataInstance.isString((Data)dataInstance)) {
            String escaped;
            StringDataInstance sdi = StringDataInstance.getStringDataInstance((Data)dataInstance);
            if (sdi.isShowTranslation()) {
                escaped = this.escapeHtml(sdi.getStringValue());
                result = (String)result + String.format("<br>Original value: %s", escaped);
            }
            if (!sdi.isShowTranslation() && sdi.getTranslatedValue() != null) {
                escaped = this.escapeHtml(sdi.getTranslatedValue());
                result = (String)result + String.format("<br>Translated value: %s", escaped);
            }
            if (sdi.isMissingNullTerminator()) {
                result = (String)result + "<br>Missing NULL terminator.";
            }
            if (sdi.getStringLength() > dataInstance.getLength()) {
                result = (String)result + "<br><font color=\"" + GThemeDefaults.Colors.Messages.ERROR.toHexString() + "\">String exceeds data field.</font>";
            }
        }
        return result;
    }

    private Data getDataForLocation(Program program, ProgramLocation location) {
        Address address;
        Listing listing = program.getListing();
        Data data = listing.getDataContaining(address = location.getAddress());
        if (data != null) {
            return data.getComponent(location.getComponentPath());
        }
        return null;
    }

    private DataType getFunctionReturnDataType(Program program, Address address) {
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionAt(address);
        if (function != null) {
            return function.getReturnType();
        }
        return null;
    }

    private JComponent createEquateToolTipComponent(Program program, Equate equate) {
        StringBuilder hoverInfo = new StringBuilder();
        if (equate.isEnumBased() && equate.isValidUUID()) {
            UniversalID id;
            ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
            Enum enoom = (Enum)dtm.findDataTypeForID(id = equate.getEnumUUID());
            if (enoom != null) {
                hoverInfo.append("<html>Equate value: " + equate.getDisplayValue() + "<hr>" + ToolTipUtils.getHTMLRepresentation((DataType)enoom).getHTMLContentString() + "</html>");
            }
        } else {
            hoverInfo.append(equate.getDisplayValue());
        }
        return this.createTooltipComponent(hoverInfo.toString());
    }
}

