/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;
import java.util.Objects;

public class FieldNameFieldLocation
extends CodeUnitLocation {
    private String fieldName;

    public FieldNameFieldLocation(Program program, Address addr, int[] componentPath, String fieldName, int charOffset) {
        super(program, addr, componentPath, 0, 0, charOffset);
        this.fieldName = fieldName;
    }

    public FieldNameFieldLocation() {
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldNameFieldLocation other = (FieldNameFieldLocation)obj;
        return Objects.equals(this.fieldName, other.fieldName);
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_FIELD_NAME", this.fieldName);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.fieldName = obj.getString("_FIELD_NAME", null);
    }

    @Override
    public String toString() {
        return super.toString() + ", Field Name = " + this.fieldName;
    }

    public Data getDataComponent() {
        Data data = this.program.getListing().getDataContaining(this.addr);
        if (data == null) {
            return null;
        }
        return data.getComponent(this.getComponentPath());
    }
}

