/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.ConvertedRecordIterator;
import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.OverlaySpaceDBAdapter;
import ghidra.program.database.ProgramAddressFactory;
import ghidra.program.database.ProgramOverlayAddressSpace;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import javax.help.UnsupportedOperationException;

class OverlaySpaceDBAdapterV0
extends OverlaySpaceDBAdapter {
    private static final int VERSION = 0;
    private static final int OV_SPACE_NAME_COL_V0 = 0;
    private static final int OV_SPACE_BASE_COL_V0 = 1;
    private Table table;

    OverlaySpaceDBAdapterV0(DBHandle dbHandle) throws VersionException {
        super(dbHandle);
        this.table = dbHandle.getTable(TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: " + TABLE_NAME);
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException(2, false);
        }
    }

    @Override
    ProgramOverlayAddressSpace createOverlaySpace(ProgramAddressFactory factory, String blockName, AddressSpace baseSpace) {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean removeOverlaySpace(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean renameOverlaySpace(String oldName, String newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    void updateOverlayRecord(DBRecord rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    void updateOverlaySpaces(ProgramAddressFactory factory) {
        throw new UnsupportedOperationException();
    }

    @Override
    void setLanguage(Language newLanguage, ProgramAddressFactory addrFactory, LanguageTranslator translator) {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getOverlayRecords() throws IOException {
        return new V0ConvertedRecordIterator(this.table.iterator());
    }

    private DBRecord convertV0Record(DBRecord v0Rec) {
        String overlayName = v0Rec.getString(0);
        String baseSpaceName = v0Rec.getString(1);
        DBRecord rec = SCHEMA.createRecord(v0Rec.getKey());
        rec.setString(0, overlayName);
        rec.setString(1, baseSpaceName);
        return rec;
    }

    private class V0ConvertedRecordIterator
    extends ConvertedRecordIterator {
        V0ConvertedRecordIterator(RecordIterator originalIterator) {
            super(originalIterator, false);
        }

        protected DBRecord convertRecord(DBRecord record) {
            return OverlaySpaceDBAdapterV0.this.convertV0Record(record);
        }
    }
}

