/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import jogamp.graph.font.typecast.ot.table.Table;

public class SVGTable
implements Table {
    public static final int VERSION = 0;
    private int _version = 0;
    private SVGDocumentRecord[] _documentRecords;

    public SVGTable(DataInput dataInput) throws IOException {
        this._version = dataInput.readUnsignedShort();
        int n = dataInput.readInt();
        dataInput.skipBytes(n - 6);
        int n2 = 0;
        int n3 = dataInput.readUnsignedShort();
        n2 += 2;
        this._documentRecords = new SVGDocumentRecord[n3];
        for (int i = 0; i < n3; ++i) {
            this._documentRecords[i] = new SVGDocumentRecord(dataInput);
        }
        n2 += n3 * 12;
        SVGDocumentRecord[] sVGDocumentRecordArray = new SVGDocumentRecord[n3];
        System.arraycopy(this._documentRecords, 0, sVGDocumentRecordArray, 0, n3);
        Arrays.sort(sVGDocumentRecordArray, (sVGDocumentRecord, sVGDocumentRecord2) -> Integer.compare(sVGDocumentRecord.getSvgDocOffset(), sVGDocumentRecord2.getSvgDocOffset()));
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            SVGDocumentRecord sVGDocumentRecord3 = sVGDocumentRecordArray[i];
            int n5 = sVGDocumentRecord3.getSvgDocOffset();
            if (n5 == n4) {
                sVGDocumentRecord3.setDocument(sVGDocumentRecordArray[i - 1].getDocument());
            } else {
                int n6 = n5 - n2;
                assert (n6 >= 0);
                dataInput.skipBytes(n6);
                n2 = n5;
            }
            n4 = n2;
            sVGDocumentRecord3.readDoc(dataInput);
            n2 += sVGDocumentRecord3.getSvgDocLength();
        }
    }

    public SVGDocumentRecord[] getDocumentRecords() {
        return this._documentRecords;
    }

    public int getVersion() {
        return this._version;
    }

    @Override
    public int getType() {
        return 0;
    }

    public String toString() {
        return "SVG Table\n---------\n  Version: " + this.getVersion() + "\n  Number of records: " + this.getDocumentRecords().length;
    }

    @Override
    public void dump(Writer writer) throws IOException {
        Table.super.dump(writer);
        for (SVGDocumentRecord sVGDocumentRecord : this.getDocumentRecords()) {
            writer.write("\n\n");
            writer.write(sVGDocumentRecord.toString());
        }
    }

    public static class SVGDocumentRecord {
        private int _startGlyphID;
        private int _endGlyphID;
        private int _svgDocOffset;
        private int _svgDocLength;
        private String _document;

        public SVGDocumentRecord(DataInput dataInput) throws IOException {
            this._startGlyphID = dataInput.readUnsignedShort();
            this._endGlyphID = dataInput.readUnsignedShort();
            this._svgDocOffset = dataInput.readInt();
            this._svgDocLength = dataInput.readInt();
        }

        public void readDoc(DataInput dataInput) throws IOException {
            byte[] byArray = new byte[this.getSvgDocLength()];
            dataInput.readFully(byArray);
            if (byArray[0] == 31 && byArray[1] == 139 && byArray[2] == 8) {
                try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));){
                    this.readDoc(gZIPInputStream);
                }
            }
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                this.readDoc(byteArrayInputStream);
            }
        }

        private void readDoc(InputStream inputStream) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[4096];
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("utf-8"));){
                int n;
                while ((n = inputStreamReader.read(cArray)) >= 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            this._document = stringBuilder.toString();
        }

        public int getStartGlyphID() {
            return this._startGlyphID;
        }

        public int getEndGlyphID() {
            return this._endGlyphID;
        }

        public int getSvgDocOffset() {
            return this._svgDocOffset;
        }

        public int getSvgDocLength() {
            return this._svgDocLength;
        }

        public String getDocument() {
            return this._document;
        }

        public void setDocument(String string) {
            this._document = string;
        }

        public String toString() {
            return "    SVG document record\n    -------------------\n      startGlyphID: " + this.getStartGlyphID() + "\n      endGlyphID:   " + this.getEndGlyphID() + "\n      svg:          " + this.getDocument();
        }
    }
}

