# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._traffic_manager_management_client_enums import *


class CheckTrafficManagerRelativeDnsNameAvailabilityParameters(msrest.serialization.Model):
    """Parameters supplied to check Traffic Manager name operation.

    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword type: The type of the resource.
        :paramtype type: str
        """
        super(CheckTrafficManagerRelativeDnsNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name
        self.type = type


class CloudErrorBody(msrest.serialization.Model):
    """The content of an error returned by the Azure Resource Manager.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar details: Error details.
    :vartype details: list[~azure.mgmt.trafficmanager.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword details: Error details.
        :paramtype details: list[~azure.mgmt.trafficmanager.models.CloudErrorBody]
        """
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class DeleteOperationResult(msrest.serialization.Model):
    """The result of the request or operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operation_result: The result of the operation or request.
    :vartype operation_result: bool
    """

    _validation = {
        'operation_result': {'readonly': True},
    }

    _attribute_map = {
        'operation_result': {'key': 'boolean', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DeleteOperationResult, self).__init__(**kwargs)
        self.operation_result = None


class DnsConfig(msrest.serialization.Model):
    """Class containing DNS settings in a Traffic Manager profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar relative_name: The relative DNS name provided by this Traffic Manager profile. This value
     is combined with the DNS domain name used by Azure Traffic Manager to form the fully-qualified
     domain name (FQDN) of the profile.
    :vartype relative_name: str
    :ivar fqdn: The fully-qualified domain name (FQDN) of the Traffic Manager profile. This is
     formed from the concatenation of the RelativeName with the DNS domain used by Azure Traffic
     Manager.
    :vartype fqdn: str
    :ivar ttl: The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and DNS
     clients how long to cache DNS responses provided by this Traffic Manager profile.
    :vartype ttl: long
    """

    _validation = {
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'relative_name': {'key': 'relativeName', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ttl': {'key': 'ttl', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        relative_name: Optional[str] = None,
        ttl: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword relative_name: The relative DNS name provided by this Traffic Manager profile. This
         value is combined with the DNS domain name used by Azure Traffic Manager to form the
         fully-qualified domain name (FQDN) of the profile.
        :paramtype relative_name: str
        :keyword ttl: The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and
         DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
        :paramtype ttl: long
        """
        super(DnsConfig, self).__init__(**kwargs)
        self.relative_name = relative_name
        self.fqdn = None
        self.ttl = ttl


class Resource(msrest.serialization.Model):
    """The core properties of ARM resources.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :vartype type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified resource Id for the resource. Ex -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
        :paramtype id: str
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
        :paramtype type: str
        """
        super(Resource, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :vartype type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified resource Id for the resource. Ex -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
        :paramtype id: str
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
        :paramtype type: str
        """
        super(ProxyResource, self).__init__(id=id, name=name, type=type, **kwargs)


class Endpoint(ProxyResource):
    """Class representing a Traffic Manager endpoint.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :vartype type: str
    :ivar target_resource_id: The Azure Resource URI of the of the endpoint. Not applicable to
     endpoints of type 'ExternalEndpoints'.
    :vartype target_resource_id: str
    :ivar target: The fully-qualified DNS name or IP address of the endpoint. Traffic Manager
     returns this value in DNS responses to direct traffic to this endpoint.
    :vartype target: str
    :ivar endpoint_status: The status of the endpoint. If the endpoint is Enabled, it is probed for
     endpoint health and is included in the traffic routing method. Possible values include:
     "Enabled", "Disabled".
    :vartype endpoint_status: str or ~azure.mgmt.trafficmanager.models.EndpointStatus
    :ivar weight: The weight of this endpoint when using the 'Weighted' traffic routing method.
     Possible values are from 1 to 1000.
    :vartype weight: long
    :ivar priority: The priority of this endpoint when using the 'Priority' traffic routing method.
     Possible values are from 1 to 1000, lower values represent higher priority. This is an optional
     parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share
     the same priority value.
    :vartype priority: long
    :ivar endpoint_location: Specifies the location of the external or nested endpoints when using
     the 'Performance' traffic routing method.
    :vartype endpoint_location: str
    :ivar endpoint_monitor_status: The monitoring status of the endpoint. Possible values include:
     "CheckingEndpoint", "Online", "Degraded", "Disabled", "Inactive", "Stopped".
    :vartype endpoint_monitor_status: str or
     ~azure.mgmt.trafficmanager.models.EndpointMonitorStatus
    :ivar min_child_endpoints: The minimum number of endpoints that must be available in the child
     profile in order for the parent profile to be considered available. Only applicable to endpoint
     of type 'NestedEndpoints'.
    :vartype min_child_endpoints: long
    :ivar min_child_endpoints_i_pv4: The minimum number of IPv4 (DNS record type A) endpoints that
     must be available in the child profile in order for the parent profile to be considered
     available. Only applicable to endpoint of type 'NestedEndpoints'.
    :vartype min_child_endpoints_i_pv4: long
    :ivar min_child_endpoints_i_pv6: The minimum number of IPv6 (DNS record type AAAA) endpoints
     that must be available in the child profile in order for the parent profile to be considered
     available. Only applicable to endpoint of type 'NestedEndpoints'.
    :vartype min_child_endpoints_i_pv6: long
    :ivar geo_mapping: The list of countries/regions mapped to this endpoint when using the
     'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation
     for a full list of accepted values.
    :vartype geo_mapping: list[str]
    :ivar subnets: The list of subnets, IP addresses, and/or address ranges mapped to this endpoint
     when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered
     by other endpoints.
    :vartype subnets: list[~azure.mgmt.trafficmanager.models.EndpointPropertiesSubnetsItem]
    :ivar custom_headers: List of custom headers.
    :vartype custom_headers:
     list[~azure.mgmt.trafficmanager.models.EndpointPropertiesCustomHeadersItem]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'str'},
        'endpoint_status': {'key': 'properties.endpointStatus', 'type': 'str'},
        'weight': {'key': 'properties.weight', 'type': 'long'},
        'priority': {'key': 'properties.priority', 'type': 'long'},
        'endpoint_location': {'key': 'properties.endpointLocation', 'type': 'str'},
        'endpoint_monitor_status': {'key': 'properties.endpointMonitorStatus', 'type': 'str'},
        'min_child_endpoints': {'key': 'properties.minChildEndpoints', 'type': 'long'},
        'min_child_endpoints_i_pv4': {'key': 'properties.minChildEndpointsIPv4', 'type': 'long'},
        'min_child_endpoints_i_pv6': {'key': 'properties.minChildEndpointsIPv6', 'type': 'long'},
        'geo_mapping': {'key': 'properties.geoMapping', 'type': '[str]'},
        'subnets': {'key': 'properties.subnets', 'type': '[EndpointPropertiesSubnetsItem]'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '[EndpointPropertiesCustomHeadersItem]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        target_resource_id: Optional[str] = None,
        target: Optional[str] = None,
        endpoint_status: Optional[Union[str, "EndpointStatus"]] = None,
        weight: Optional[int] = None,
        priority: Optional[int] = None,
        endpoint_location: Optional[str] = None,
        endpoint_monitor_status: Optional[Union[str, "EndpointMonitorStatus"]] = None,
        min_child_endpoints: Optional[int] = None,
        min_child_endpoints_i_pv4: Optional[int] = None,
        min_child_endpoints_i_pv6: Optional[int] = None,
        geo_mapping: Optional[List[str]] = None,
        subnets: Optional[List["EndpointPropertiesSubnetsItem"]] = None,
        custom_headers: Optional[List["EndpointPropertiesCustomHeadersItem"]] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified resource Id for the resource. Ex -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
        :paramtype id: str
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
        :paramtype type: str
        :keyword target_resource_id: The Azure Resource URI of the of the endpoint. Not applicable to
         endpoints of type 'ExternalEndpoints'.
        :paramtype target_resource_id: str
        :keyword target: The fully-qualified DNS name or IP address of the endpoint. Traffic Manager
         returns this value in DNS responses to direct traffic to this endpoint.
        :paramtype target: str
        :keyword endpoint_status: The status of the endpoint. If the endpoint is Enabled, it is probed
         for endpoint health and is included in the traffic routing method. Possible values include:
         "Enabled", "Disabled".
        :paramtype endpoint_status: str or ~azure.mgmt.trafficmanager.models.EndpointStatus
        :keyword weight: The weight of this endpoint when using the 'Weighted' traffic routing method.
         Possible values are from 1 to 1000.
        :paramtype weight: long
        :keyword priority: The priority of this endpoint when using the 'Priority' traffic routing
         method. Possible values are from 1 to 1000, lower values represent higher priority. This is an
         optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints
         can share the same priority value.
        :paramtype priority: long
        :keyword endpoint_location: Specifies the location of the external or nested endpoints when
         using the 'Performance' traffic routing method.
        :paramtype endpoint_location: str
        :keyword endpoint_monitor_status: The monitoring status of the endpoint. Possible values
         include: "CheckingEndpoint", "Online", "Degraded", "Disabled", "Inactive", "Stopped".
        :paramtype endpoint_monitor_status: str or
         ~azure.mgmt.trafficmanager.models.EndpointMonitorStatus
        :keyword min_child_endpoints: The minimum number of endpoints that must be available in the
         child profile in order for the parent profile to be considered available. Only applicable to
         endpoint of type 'NestedEndpoints'.
        :paramtype min_child_endpoints: long
        :keyword min_child_endpoints_i_pv4: The minimum number of IPv4 (DNS record type A) endpoints
         that must be available in the child profile in order for the parent profile to be considered
         available. Only applicable to endpoint of type 'NestedEndpoints'.
        :paramtype min_child_endpoints_i_pv4: long
        :keyword min_child_endpoints_i_pv6: The minimum number of IPv6 (DNS record type AAAA) endpoints
         that must be available in the child profile in order for the parent profile to be considered
         available. Only applicable to endpoint of type 'NestedEndpoints'.
        :paramtype min_child_endpoints_i_pv6: long
        :keyword geo_mapping: The list of countries/regions mapped to this endpoint when using the
         'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation
         for a full list of accepted values.
        :paramtype geo_mapping: list[str]
        :keyword subnets: The list of subnets, IP addresses, and/or address ranges mapped to this
         endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges
         not covered by other endpoints.
        :paramtype subnets: list[~azure.mgmt.trafficmanager.models.EndpointPropertiesSubnetsItem]
        :keyword custom_headers: List of custom headers.
        :paramtype custom_headers:
         list[~azure.mgmt.trafficmanager.models.EndpointPropertiesCustomHeadersItem]
        """
        super(Endpoint, self).__init__(id=id, name=name, type=type, **kwargs)
        self.target_resource_id = target_resource_id
        self.target = target
        self.endpoint_status = endpoint_status
        self.weight = weight
        self.priority = priority
        self.endpoint_location = endpoint_location
        self.endpoint_monitor_status = endpoint_monitor_status
        self.min_child_endpoints = min_child_endpoints
        self.min_child_endpoints_i_pv4 = min_child_endpoints_i_pv4
        self.min_child_endpoints_i_pv6 = min_child_endpoints_i_pv6
        self.geo_mapping = geo_mapping
        self.subnets = subnets
        self.custom_headers = custom_headers


class EndpointPropertiesCustomHeadersItem(msrest.serialization.Model):
    """Custom header name and value.

    :ivar name: Header name.
    :vartype name: str
    :ivar value: Header value.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Header name.
        :paramtype name: str
        :keyword value: Header value.
        :paramtype value: str
        """
        super(EndpointPropertiesCustomHeadersItem, self).__init__(**kwargs)
        self.name = name
        self.value = value


class EndpointPropertiesSubnetsItem(msrest.serialization.Model):
    """Subnet first address, scope, and/or last address.

    :ivar first: First address in the subnet.
    :vartype first: str
    :ivar last: Last address in the subnet.
    :vartype last: str
    :ivar scope: Block size (number of leading bits in the subnet mask).
    :vartype scope: int
    """

    _attribute_map = {
        'first': {'key': 'first', 'type': 'str'},
        'last': {'key': 'last', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        first: Optional[str] = None,
        last: Optional[str] = None,
        scope: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword first: First address in the subnet.
        :paramtype first: str
        :keyword last: Last address in the subnet.
        :paramtype last: str
        :keyword scope: Block size (number of leading bits in the subnet mask).
        :paramtype scope: int
        """
        super(EndpointPropertiesSubnetsItem, self).__init__(**kwargs)
        self.first = first
        self.last = last
        self.scope = scope


class HeatMapEndpoint(msrest.serialization.Model):
    """Class which is a sparse representation of a Traffic Manager endpoint.

    :ivar resource_id: The ARM Resource ID of this Traffic Manager endpoint.
    :vartype resource_id: str
    :ivar endpoint_id: A number uniquely identifying this endpoint in query experiences.
    :vartype endpoint_id: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'endpoint_id': {'key': 'endpointId', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        endpoint_id: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword resource_id: The ARM Resource ID of this Traffic Manager endpoint.
        :paramtype resource_id: str
        :keyword endpoint_id: A number uniquely identifying this endpoint in query experiences.
        :paramtype endpoint_id: int
        """
        super(HeatMapEndpoint, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.endpoint_id = endpoint_id


class HeatMapModel(ProxyResource):
    """Class representing a Traffic Manager HeatMap.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :vartype type: str
    :ivar start_time: The beginning of the time window for this HeatMap, inclusive.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The ending of the time window for this HeatMap, exclusive.
    :vartype end_time: ~datetime.datetime
    :ivar endpoints: The endpoints used in this HeatMap calculation.
    :vartype endpoints: list[~azure.mgmt.trafficmanager.models.HeatMapEndpoint]
    :ivar traffic_flows: The traffic flows produced in this HeatMap calculation.
    :vartype traffic_flows: list[~azure.mgmt.trafficmanager.models.TrafficFlow]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[HeatMapEndpoint]'},
        'traffic_flows': {'key': 'properties.trafficFlows', 'type': '[TrafficFlow]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        endpoints: Optional[List["HeatMapEndpoint"]] = None,
        traffic_flows: Optional[List["TrafficFlow"]] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified resource Id for the resource. Ex -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
        :paramtype id: str
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
        :paramtype type: str
        :keyword start_time: The beginning of the time window for this HeatMap, inclusive.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The ending of the time window for this HeatMap, exclusive.
        :paramtype end_time: ~datetime.datetime
        :keyword endpoints: The endpoints used in this HeatMap calculation.
        :paramtype endpoints: list[~azure.mgmt.trafficmanager.models.HeatMapEndpoint]
        :keyword traffic_flows: The traffic flows produced in this HeatMap calculation.
        :paramtype traffic_flows: list[~azure.mgmt.trafficmanager.models.TrafficFlow]
        """
        super(HeatMapModel, self).__init__(id=id, name=name, type=type, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.endpoints = endpoints
        self.traffic_flows = traffic_flows


class MonitorConfig(msrest.serialization.Model):
    """Class containing endpoint monitoring settings in a Traffic Manager profile.

    :ivar profile_monitor_status: The profile-level monitoring status of the Traffic Manager
     profile. Possible values include: "CheckingEndpoints", "Online", "Degraded", "Disabled",
     "Inactive".
    :vartype profile_monitor_status: str or ~azure.mgmt.trafficmanager.models.ProfileMonitorStatus
    :ivar protocol: The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health. Possible
     values include: "HTTP", "HTTPS", "TCP".
    :vartype protocol: str or ~azure.mgmt.trafficmanager.models.MonitorProtocol
    :ivar port: The TCP port used to probe for endpoint health.
    :vartype port: long
    :ivar path: The path relative to the endpoint domain name used to probe for endpoint health.
    :vartype path: str
    :ivar interval_in_seconds: The monitor interval for endpoints in this profile. This is the
     interval at which Traffic Manager will check the health of each endpoint in this profile.
    :vartype interval_in_seconds: long
    :ivar timeout_in_seconds: The monitor timeout for endpoints in this profile. This is the time
     that Traffic Manager allows endpoints in this profile to response to the health check.
    :vartype timeout_in_seconds: long
    :ivar tolerated_number_of_failures: The number of consecutive failed health check that Traffic
     Manager tolerates before declaring an endpoint in this profile Degraded after the next failed
     health check.
    :vartype tolerated_number_of_failures: long
    :ivar custom_headers: List of custom headers.
    :vartype custom_headers: list[~azure.mgmt.trafficmanager.models.MonitorConfigCustomHeadersItem]
    :ivar expected_status_code_ranges: List of expected status code ranges.
    :vartype expected_status_code_ranges:
     list[~azure.mgmt.trafficmanager.models.MonitorConfigExpectedStatusCodeRangesItem]
    """

    _attribute_map = {
        'profile_monitor_status': {'key': 'profileMonitorStatus', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'port': {'key': 'port', 'type': 'long'},
        'path': {'key': 'path', 'type': 'str'},
        'interval_in_seconds': {'key': 'intervalInSeconds', 'type': 'long'},
        'timeout_in_seconds': {'key': 'timeoutInSeconds', 'type': 'long'},
        'tolerated_number_of_failures': {'key': 'toleratedNumberOfFailures', 'type': 'long'},
        'custom_headers': {'key': 'customHeaders', 'type': '[MonitorConfigCustomHeadersItem]'},
        'expected_status_code_ranges': {'key': 'expectedStatusCodeRanges', 'type': '[MonitorConfigExpectedStatusCodeRangesItem]'},
    }

    def __init__(
        self,
        *,
        profile_monitor_status: Optional[Union[str, "ProfileMonitorStatus"]] = None,
        protocol: Optional[Union[str, "MonitorProtocol"]] = None,
        port: Optional[int] = None,
        path: Optional[str] = None,
        interval_in_seconds: Optional[int] = None,
        timeout_in_seconds: Optional[int] = None,
        tolerated_number_of_failures: Optional[int] = None,
        custom_headers: Optional[List["MonitorConfigCustomHeadersItem"]] = None,
        expected_status_code_ranges: Optional[List["MonitorConfigExpectedStatusCodeRangesItem"]] = None,
        **kwargs
    ):
        """
        :keyword profile_monitor_status: The profile-level monitoring status of the Traffic Manager
         profile. Possible values include: "CheckingEndpoints", "Online", "Degraded", "Disabled",
         "Inactive".
        :paramtype profile_monitor_status: str or
         ~azure.mgmt.trafficmanager.models.ProfileMonitorStatus
        :keyword protocol: The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
         Possible values include: "HTTP", "HTTPS", "TCP".
        :paramtype protocol: str or ~azure.mgmt.trafficmanager.models.MonitorProtocol
        :keyword port: The TCP port used to probe for endpoint health.
        :paramtype port: long
        :keyword path: The path relative to the endpoint domain name used to probe for endpoint health.
        :paramtype path: str
        :keyword interval_in_seconds: The monitor interval for endpoints in this profile. This is the
         interval at which Traffic Manager will check the health of each endpoint in this profile.
        :paramtype interval_in_seconds: long
        :keyword timeout_in_seconds: The monitor timeout for endpoints in this profile. This is the
         time that Traffic Manager allows endpoints in this profile to response to the health check.
        :paramtype timeout_in_seconds: long
        :keyword tolerated_number_of_failures: The number of consecutive failed health check that
         Traffic Manager tolerates before declaring an endpoint in this profile Degraded after the next
         failed health check.
        :paramtype tolerated_number_of_failures: long
        :keyword custom_headers: List of custom headers.
        :paramtype custom_headers:
         list[~azure.mgmt.trafficmanager.models.MonitorConfigCustomHeadersItem]
        :keyword expected_status_code_ranges: List of expected status code ranges.
        :paramtype expected_status_code_ranges:
         list[~azure.mgmt.trafficmanager.models.MonitorConfigExpectedStatusCodeRangesItem]
        """
        super(MonitorConfig, self).__init__(**kwargs)
        self.profile_monitor_status = profile_monitor_status
        self.protocol = protocol
        self.port = port
        self.path = path
        self.interval_in_seconds = interval_in_seconds
        self.timeout_in_seconds = timeout_in_seconds
        self.tolerated_number_of_failures = tolerated_number_of_failures
        self.custom_headers = custom_headers
        self.expected_status_code_ranges = expected_status_code_ranges


class MonitorConfigCustomHeadersItem(msrest.serialization.Model):
    """Custom header name and value.

    :ivar name: Header name.
    :vartype name: str
    :ivar value: Header value.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Header name.
        :paramtype name: str
        :keyword value: Header value.
        :paramtype value: str
        """
        super(MonitorConfigCustomHeadersItem, self).__init__(**kwargs)
        self.name = name
        self.value = value


class MonitorConfigExpectedStatusCodeRangesItem(msrest.serialization.Model):
    """Min and max value of a status code range.

    :ivar min: Min status code.
    :vartype min: int
    :ivar max: Max status code.
    :vartype max: int
    """

    _attribute_map = {
        'min': {'key': 'min', 'type': 'int'},
        'max': {'key': 'max', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min: Optional[int] = None,
        max: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword min: Min status code.
        :paramtype min: int
        :keyword max: Max status code.
        :paramtype max: int
        """
        super(MonitorConfigExpectedStatusCodeRangesItem, self).__init__(**kwargs)
        self.min = min
        self.max = max


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The Azure Region where the resource lives.
    :vartype location: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified resource Id for the resource. Ex -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
        :paramtype id: str
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
        :paramtype type: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The Azure Region where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(id=id, name=name, type=type, **kwargs)
        self.tags = tags
        self.location = location


class Profile(TrackedResource):
    """Class representing a Traffic Manager profile.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The Azure Region where the resource lives.
    :vartype location: str
    :ivar profile_status: The status of the Traffic Manager profile. Possible values include:
     "Enabled", "Disabled".
    :vartype profile_status: str or ~azure.mgmt.trafficmanager.models.ProfileStatus
    :ivar traffic_routing_method: The traffic routing method of the Traffic Manager profile.
     Possible values include: "Performance", "Priority", "Weighted", "Geographic", "MultiValue",
     "Subnet".
    :vartype traffic_routing_method: str or ~azure.mgmt.trafficmanager.models.TrafficRoutingMethod
    :ivar dns_config: The DNS settings of the Traffic Manager profile.
    :vartype dns_config: ~azure.mgmt.trafficmanager.models.DnsConfig
    :ivar monitor_config: The endpoint monitoring settings of the Traffic Manager profile.
    :vartype monitor_config: ~azure.mgmt.trafficmanager.models.MonitorConfig
    :ivar endpoints: The list of endpoints in the Traffic Manager profile.
    :vartype endpoints: list[~azure.mgmt.trafficmanager.models.Endpoint]
    :ivar traffic_view_enrollment_status: Indicates whether Traffic View is 'Enabled' or 'Disabled'
     for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature will
     increase the cost of the Traffic Manage profile. Possible values include: "Enabled",
     "Disabled".
    :vartype traffic_view_enrollment_status: str or
     ~azure.mgmt.trafficmanager.models.TrafficViewEnrollmentStatus
    :ivar allowed_endpoint_record_types: The list of allowed endpoint record types.
    :vartype allowed_endpoint_record_types: list[str or
     ~azure.mgmt.trafficmanager.models.AllowedEndpointRecordType]
    :ivar max_return: Maximum number of endpoints to be returned for MultiValue routing type.
    :vartype max_return: long
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'profile_status': {'key': 'properties.profileStatus', 'type': 'str'},
        'traffic_routing_method': {'key': 'properties.trafficRoutingMethod', 'type': 'str'},
        'dns_config': {'key': 'properties.dnsConfig', 'type': 'DnsConfig'},
        'monitor_config': {'key': 'properties.monitorConfig', 'type': 'MonitorConfig'},
        'endpoints': {'key': 'properties.endpoints', 'type': '[Endpoint]'},
        'traffic_view_enrollment_status': {'key': 'properties.trafficViewEnrollmentStatus', 'type': 'str'},
        'allowed_endpoint_record_types': {'key': 'properties.allowedEndpointRecordTypes', 'type': '[str]'},
        'max_return': {'key': 'properties.maxReturn', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        profile_status: Optional[Union[str, "ProfileStatus"]] = None,
        traffic_routing_method: Optional[Union[str, "TrafficRoutingMethod"]] = None,
        dns_config: Optional["DnsConfig"] = None,
        monitor_config: Optional["MonitorConfig"] = None,
        endpoints: Optional[List["Endpoint"]] = None,
        traffic_view_enrollment_status: Optional[Union[str, "TrafficViewEnrollmentStatus"]] = None,
        allowed_endpoint_record_types: Optional[List[Union[str, "AllowedEndpointRecordType"]]] = None,
        max_return: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified resource Id for the resource. Ex -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
        :paramtype id: str
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
        :paramtype type: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The Azure Region where the resource lives.
        :paramtype location: str
        :keyword profile_status: The status of the Traffic Manager profile. Possible values include:
         "Enabled", "Disabled".
        :paramtype profile_status: str or ~azure.mgmt.trafficmanager.models.ProfileStatus
        :keyword traffic_routing_method: The traffic routing method of the Traffic Manager profile.
         Possible values include: "Performance", "Priority", "Weighted", "Geographic", "MultiValue",
         "Subnet".
        :paramtype traffic_routing_method: str or
         ~azure.mgmt.trafficmanager.models.TrafficRoutingMethod
        :keyword dns_config: The DNS settings of the Traffic Manager profile.
        :paramtype dns_config: ~azure.mgmt.trafficmanager.models.DnsConfig
        :keyword monitor_config: The endpoint monitoring settings of the Traffic Manager profile.
        :paramtype monitor_config: ~azure.mgmt.trafficmanager.models.MonitorConfig
        :keyword endpoints: The list of endpoints in the Traffic Manager profile.
        :paramtype endpoints: list[~azure.mgmt.trafficmanager.models.Endpoint]
        :keyword traffic_view_enrollment_status: Indicates whether Traffic View is 'Enabled' or
         'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature
         will increase the cost of the Traffic Manage profile. Possible values include: "Enabled",
         "Disabled".
        :paramtype traffic_view_enrollment_status: str or
         ~azure.mgmt.trafficmanager.models.TrafficViewEnrollmentStatus
        :keyword allowed_endpoint_record_types: The list of allowed endpoint record types.
        :paramtype allowed_endpoint_record_types: list[str or
         ~azure.mgmt.trafficmanager.models.AllowedEndpointRecordType]
        :keyword max_return: Maximum number of endpoints to be returned for MultiValue routing type.
        :paramtype max_return: long
        """
        super(Profile, self).__init__(id=id, name=name, type=type, tags=tags, location=location, **kwargs)
        self.profile_status = profile_status
        self.traffic_routing_method = traffic_routing_method
        self.dns_config = dns_config
        self.monitor_config = monitor_config
        self.endpoints = endpoints
        self.traffic_view_enrollment_status = traffic_view_enrollment_status
        self.allowed_endpoint_record_types = allowed_endpoint_record_types
        self.max_return = max_return


class ProfileListResult(msrest.serialization.Model):
    """The list Traffic Manager profiles operation response.

    :ivar value: Gets the list of Traffic manager profiles.
    :vartype value: list[~azure.mgmt.trafficmanager.models.Profile]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Profile]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Profile"]] = None,
        **kwargs
    ):
        """
        :keyword value: Gets the list of Traffic manager profiles.
        :paramtype value: list[~azure.mgmt.trafficmanager.models.Profile]
        """
        super(ProfileListResult, self).__init__(**kwargs)
        self.value = value


class QueryExperience(msrest.serialization.Model):
    """Class representing a Traffic Manager HeatMap query experience properties.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_id: Required. The id of the endpoint from the 'endpoints' array which these
     queries were routed to.
    :vartype endpoint_id: int
    :ivar query_count: Required. The number of queries originating from this location.
    :vartype query_count: int
    :ivar latency: The latency experienced by queries originating from this location.
    :vartype latency: float
    """

    _validation = {
        'endpoint_id': {'required': True},
        'query_count': {'required': True},
    }

    _attribute_map = {
        'endpoint_id': {'key': 'endpointId', 'type': 'int'},
        'query_count': {'key': 'queryCount', 'type': 'int'},
        'latency': {'key': 'latency', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        endpoint_id: int,
        query_count: int,
        latency: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword endpoint_id: Required. The id of the endpoint from the 'endpoints' array which these
         queries were routed to.
        :paramtype endpoint_id: int
        :keyword query_count: Required. The number of queries originating from this location.
        :paramtype query_count: int
        :keyword latency: The latency experienced by queries originating from this location.
        :paramtype latency: float
        """
        super(QueryExperience, self).__init__(**kwargs)
        self.endpoint_id = endpoint_id
        self.query_count = query_count
        self.latency = latency


class Region(msrest.serialization.Model):
    """Class representing a region in the Geographic hierarchy used with the Geographic traffic routing method.

    :ivar code: The code of the region.
    :vartype code: str
    :ivar name: The name of the region.
    :vartype name: str
    :ivar regions: The list of Regions grouped under this Region in the Geographic Hierarchy.
    :vartype regions: list[~azure.mgmt.trafficmanager.models.Region]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'regions': {'key': 'regions', 'type': '[Region]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        name: Optional[str] = None,
        regions: Optional[List["Region"]] = None,
        **kwargs
    ):
        """
        :keyword code: The code of the region.
        :paramtype code: str
        :keyword name: The name of the region.
        :paramtype name: str
        :keyword regions: The list of Regions grouped under this Region in the Geographic Hierarchy.
        :paramtype regions: list[~azure.mgmt.trafficmanager.models.Region]
        """
        super(Region, self).__init__(**kwargs)
        self.code = code
        self.name = name
        self.regions = regions


class TrafficFlow(msrest.serialization.Model):
    """Class representing a Traffic Manager HeatMap traffic flow properties.

    :ivar source_ip: The IP address that this query experience originated from.
    :vartype source_ip: str
    :ivar latitude: The approximate latitude that these queries originated from.
    :vartype latitude: float
    :ivar longitude: The approximate longitude that these queries originated from.
    :vartype longitude: float
    :ivar query_experiences: The query experiences produced in this HeatMap calculation.
    :vartype query_experiences: list[~azure.mgmt.trafficmanager.models.QueryExperience]
    """

    _attribute_map = {
        'source_ip': {'key': 'sourceIp', 'type': 'str'},
        'latitude': {'key': 'latitude', 'type': 'float'},
        'longitude': {'key': 'longitude', 'type': 'float'},
        'query_experiences': {'key': 'queryExperiences', 'type': '[QueryExperience]'},
    }

    def __init__(
        self,
        *,
        source_ip: Optional[str] = None,
        latitude: Optional[float] = None,
        longitude: Optional[float] = None,
        query_experiences: Optional[List["QueryExperience"]] = None,
        **kwargs
    ):
        """
        :keyword source_ip: The IP address that this query experience originated from.
        :paramtype source_ip: str
        :keyword latitude: The approximate latitude that these queries originated from.
        :paramtype latitude: float
        :keyword longitude: The approximate longitude that these queries originated from.
        :paramtype longitude: float
        :keyword query_experiences: The query experiences produced in this HeatMap calculation.
        :paramtype query_experiences: list[~azure.mgmt.trafficmanager.models.QueryExperience]
        """
        super(TrafficFlow, self).__init__(**kwargs)
        self.source_ip = source_ip
        self.latitude = latitude
        self.longitude = longitude
        self.query_experiences = query_experiences


class TrafficManagerGeographicHierarchy(ProxyResource):
    """Class representing the Geographic hierarchy used with the Geographic traffic routing method.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :vartype type: str
    :ivar geographic_hierarchy: The region at the root of the hierarchy from all the regions in the
     hierarchy can be retrieved.
    :vartype geographic_hierarchy: ~azure.mgmt.trafficmanager.models.Region
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'geographic_hierarchy': {'key': 'properties.geographicHierarchy', 'type': 'Region'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        geographic_hierarchy: Optional["Region"] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified resource Id for the resource. Ex -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
        :paramtype id: str
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
        :paramtype type: str
        :keyword geographic_hierarchy: The region at the root of the hierarchy from all the regions in
         the hierarchy can be retrieved.
        :paramtype geographic_hierarchy: ~azure.mgmt.trafficmanager.models.Region
        """
        super(TrafficManagerGeographicHierarchy, self).__init__(id=id, name=name, type=type, **kwargs)
        self.geographic_hierarchy = geographic_hierarchy


class TrafficManagerNameAvailability(msrest.serialization.Model):
    """Class representing a Traffic Manager Name Availability response.

    :ivar name: The relative name.
    :vartype name: str
    :ivar type: Traffic Manager profile resource type.
    :vartype type: str
    :ivar name_available: Describes whether the relative name is available or not.
    :vartype name_available: bool
    :ivar reason: The reason why the name is not available, when applicable.
    :vartype reason: str
    :ivar message: Descriptive message that explains why the name is not available, when
     applicable.
    :vartype message: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The relative name.
        :paramtype name: str
        :keyword type: Traffic Manager profile resource type.
        :paramtype type: str
        :keyword name_available: Describes whether the relative name is available or not.
        :paramtype name_available: bool
        :keyword reason: The reason why the name is not available, when applicable.
        :paramtype reason: str
        :keyword message: Descriptive message that explains why the name is not available, when
         applicable.
        :paramtype message: str
        """
        super(TrafficManagerNameAvailability, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.name_available = name_available
        self.reason = reason
        self.message = message


class UserMetricsModel(ProxyResource):
    """Class representing Traffic Manager User Metrics.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
    :vartype type: str
    :ivar key: The key returned by the User Metrics operation.
    :vartype key: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key': {'key': 'properties.key', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified resource Id for the resource. Ex -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
        :paramtype id: str
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
        :paramtype type: str
        :keyword key: The key returned by the User Metrics operation.
        :paramtype key: str
        """
        super(UserMetricsModel, self).__init__(id=id, name=name, type=type, **kwargs)
        self.key = key
