﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/devicefarm/DeviceFarm_EXPORTS.h>
#include <aws/devicefarm/model/Suite.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DeviceFarm {
namespace Model {
/**
 * <p>Represents the result of a list suites request.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuitesResult">AWS
 * API Reference</a></p>
 */
class ListSuitesResult {
 public:
  AWS_DEVICEFARM_API ListSuitesResult() = default;
  AWS_DEVICEFARM_API ListSuitesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DEVICEFARM_API ListSuitesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the suites.</p>
   */
  inline const Aws::Vector<Suite>& GetSuites() const { return m_suites; }
  template <typename SuitesT = Aws::Vector<Suite>>
  void SetSuites(SuitesT&& value) {
    m_suitesHasBeenSet = true;
    m_suites = std::forward<SuitesT>(value);
  }
  template <typename SuitesT = Aws::Vector<Suite>>
  ListSuitesResult& WithSuites(SuitesT&& value) {
    SetSuites(std::forward<SuitesT>(value));
    return *this;
  }
  template <typename SuitesT = Suite>
  ListSuitesResult& AddSuites(SuitesT&& value) {
    m_suitesHasBeenSet = true;
    m_suites.emplace_back(std::forward<SuitesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the number of items that are returned is significantly large, this is an
   * identifier that is also returned. It can be used in a subsequent call to this
   * operation to return the next set of items in the list.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListSuitesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListSuitesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Suite> m_suites;
  bool m_suitesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DeviceFarm
}  // namespace Aws
