/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.googlejavaformat.java.AutoValue_JavaFormatterOptions;

@Immutable
@AutoValue
public abstract class JavaFormatterOptions {
    public int indentationMultiplier() {
        return this.style().indentationMultiplier();
    }

    public abstract boolean formatJavadoc();

    public abstract boolean reorderModifiers();

    public abstract Style style();

    public static JavaFormatterOptions defaultOptions() {
        return JavaFormatterOptions.builder().build();
    }

    public static Builder builder() {
        return new AutoValue_JavaFormatterOptions.Builder().style(Style.GOOGLE).formatJavadoc(true).reorderModifiers(true);
    }

    public static enum Style {
        GOOGLE(1),
        AOSP(2);

        private final int indentationMultiplier;

        private Style(int indentationMultiplier) {
            this.indentationMultiplier = indentationMultiplier;
        }

        int indentationMultiplier() {
            return this.indentationMultiplier;
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder style(Style var1);

        public abstract Builder formatJavadoc(boolean var1);

        public abstract Builder reorderModifiers(boolean var1);

        public abstract JavaFormatterOptions build();
    }
}

