/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.model.KeyBlob;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;

public final class EncryptionMaterials {
    private final CryptoAlgorithm algorithm;
    private final Map<String, String> encryptionContext;
    private final List<KeyBlob> encryptedDataKeys;
    private final SecretKey cleartextDataKey;
    private final PrivateKey trailingSignatureKey;
    private final List<MasterKey> masterKeys;

    private EncryptionMaterials(Builder b) {
        this.algorithm = b.algorithm;
        this.encryptionContext = b.encryptionContext;
        this.encryptedDataKeys = b.encryptedDataKeys;
        this.cleartextDataKey = b.cleartextDataKey;
        this.trailingSignatureKey = b.trailingSignatureKey;
        this.masterKeys = b.getMasterKeys();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CryptoAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    public List<KeyBlob> getEncryptedDataKeys() {
        return this.encryptedDataKeys;
    }

    public SecretKey getCleartextDataKey() {
        return this.cleartextDataKey;
    }

    public PrivateKey getTrailingSignatureKey() {
        return this.trailingSignatureKey;
    }

    public List<MasterKey> getMasterKeys() {
        return this.masterKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionMaterials that = (EncryptionMaterials)o;
        return this.algorithm == that.algorithm && Objects.equals(this.encryptionContext, that.encryptionContext) && Objects.equals(this.encryptedDataKeys, that.encryptedDataKeys) && Objects.equals(this.cleartextDataKey, that.cleartextDataKey) && Objects.equals(this.trailingSignatureKey, that.trailingSignatureKey) && Objects.equals(this.masterKeys, that.masterKeys);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm, this.encryptionContext, this.encryptedDataKeys, this.cleartextDataKey, this.trailingSignatureKey, this.masterKeys});
    }

    public static class Builder {
        private CryptoAlgorithm algorithm;
        private Map<String, String> encryptionContext = Collections.emptyMap();
        private List<KeyBlob> encryptedDataKeys = null;
        private SecretKey cleartextDataKey;
        private PrivateKey trailingSignatureKey;
        private List<MasterKey> masterKeys = Collections.emptyList();

        private Builder() {
        }

        private Builder(EncryptionMaterials r) {
            this.algorithm = r.algorithm;
            this.encryptionContext = r.encryptionContext;
            this.encryptedDataKeys = r.encryptedDataKeys;
            this.cleartextDataKey = r.cleartextDataKey;
            this.trailingSignatureKey = r.trailingSignatureKey;
            this.setMasterKeys(r.masterKeys);
        }

        public EncryptionMaterials build() {
            return new EncryptionMaterials(this);
        }

        public CryptoAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public Builder setAlgorithm(CryptoAlgorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Map<String, String> getEncryptionContext() {
            return this.encryptionContext;
        }

        public Builder setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = Collections.unmodifiableMap(new HashMap<String, String>(encryptionContext));
            return this;
        }

        public List<KeyBlob> getEncryptedDataKeys() {
            return this.encryptedDataKeys;
        }

        public Builder setEncryptedDataKeys(List<KeyBlob> encryptedDataKeys) {
            this.encryptedDataKeys = Collections.unmodifiableList(new ArrayList<KeyBlob>(encryptedDataKeys));
            return this;
        }

        public SecretKey getCleartextDataKey() {
            return this.cleartextDataKey;
        }

        public Builder setCleartextDataKey(SecretKey cleartextDataKey) {
            this.cleartextDataKey = cleartextDataKey;
            return this;
        }

        public PrivateKey getTrailingSignatureKey() {
            return this.trailingSignatureKey;
        }

        public Builder setTrailingSignatureKey(PrivateKey trailingSignatureKey) {
            this.trailingSignatureKey = trailingSignatureKey;
            return this;
        }

        public List<MasterKey> getMasterKeys() {
            return this.masterKeys;
        }

        public Builder setMasterKeys(List<MasterKey> masterKeys) {
            this.masterKeys = Collections.unmodifiableList(new ArrayList<MasterKey>(masterKeys));
            return this;
        }
    }
}

