"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MDSEnabledClientService = void 0;
class MDSEnabledClientService {
  constructor(osDriver, dataSourceEnabled) {
    this.osDriver = osDriver;
    this.dataSourceEnabled = dataSourceEnabled;
  }
  getClientBasedOnDataSource(context, request) {
    const dataSourceId = request.query.dataSourceId;
    return this.dataSourceEnabled && dataSourceId ? context.dataSource.opensearch.legacy.getClient(dataSourceId.toString()).callAPI : this.osDriver.asScoped(request).callAsCurrentUser;
  }
}
exports.MDSEnabledClientService = MDSEnabledClientService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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