/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.mapper.FlatObjectFieldMapper;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.lookup.SourceLookup;

public final class DocValueFetcher
implements ValueFetcher {
    private final DocValueFormat format;
    private final IndexFieldData<?> ifd;
    private Leaf leaf;

    public DocValueFetcher(DocValueFormat format, IndexFieldData<?> ifd) {
        this.format = format;
        this.ifd = ifd;
    }

    @Override
    public void setNextReader(LeafReaderContext context) {
        this.leaf = this.ifd.load(context).getLeafValueFetcher(this.format);
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) throws IOException {
        if (!this.leaf.advanceExact(lookup.docId())) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.leaf.docValueCount());
        int count = this.leaf.docValueCount();
        for (int i = 0; i < count; ++i) {
            Object value = this.leaf.nextValue();
            if (value == FlatObjectFieldMapper.DOC_VALUE_NO_MATCH) continue;
            result.add(value);
        }
        return result;
    }

    @PublicApi(since="1.0.0")
    public static interface Leaf {
        public boolean advanceExact(int var1) throws IOException;

        public int docValueCount() throws IOException;

        public Object nextValue() throws IOException;
    }
}

