/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Map;
import org.apache.kafka.server.common.FeatureVersion;
import org.apache.kafka.server.common.MetadataVersion;

public enum GroupVersion implements FeatureVersion
{
    GV_0(0, MetadataVersion.MINIMUM_VERSION, Map.of()),
    GV_1(1, MetadataVersion.IBP_4_0_IV0, Map.of());

    public static final String FEATURE_NAME = "group.version";
    public static final GroupVersion LATEST_PRODUCTION;
    private final short featureLevel;
    private final MetadataVersion bootstrapMetadataVersion;
    private final Map<String, Short> dependencies;

    private GroupVersion(int featureLevel, MetadataVersion bootstrapMetadataVersion, Map<String, Short> dependencies) {
        this.featureLevel = (short)featureLevel;
        this.bootstrapMetadataVersion = bootstrapMetadataVersion;
        this.dependencies = dependencies;
    }

    @Override
    public short featureLevel() {
        return this.featureLevel;
    }

    @Override
    public String featureName() {
        return FEATURE_NAME;
    }

    @Override
    public MetadataVersion bootstrapMetadataVersion() {
        return this.bootstrapMetadataVersion;
    }

    @Override
    public Map<String, Short> dependencies() {
        return this.dependencies;
    }

    public boolean isConsumerRebalanceProtocolSupported() {
        return this.featureLevel >= GroupVersion.GV_1.featureLevel;
    }

    public static GroupVersion fromFeatureLevel(short version) {
        switch (version) {
            case 0: {
                return GV_0;
            }
            case 1: {
                return GV_1;
            }
        }
        throw new RuntimeException("Unknown group feature level: " + version);
    }

    static {
        LATEST_PRODUCTION = GV_1;
    }
}

