/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.quota;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.server.quota.SensorAccess;

public class RLMQuotaMetrics {
    private final Sensor sensor;

    public RLMQuotaMetrics(Metrics metrics, String name, String group, String descriptionFormat, long expirationTime) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        SensorAccess sensorAccess = new SensorAccess((ReadWriteLock)lock, metrics);
        this.sensor = sensorAccess.getOrCreate(name, expirationTime, s -> {
            s.add(metrics.metricName(name + "-avg", group, String.format(descriptionFormat, "average")), (MeasurableStat)new Avg());
            s.add(metrics.metricName(name + "-max", group, String.format(descriptionFormat, "maximum")), (MeasurableStat)new Max());
        });
    }

    public Sensor sensor() {
        return this.sensor;
    }
}

