(* hivex generated file
 * WARNING: THIS FILE IS GENERATED FROM:
 *   generator/generator.ml
 * ANY CHANGES YOU MAKE TO THIS FILE WILL BE LOST.
 *
 * Copyright (C) 2009-2022 Red Hat Inc.
 * Derived from code by Petter Nordahl-Hagen under a compatible license:
 *   Copyright (c) 1997-2007 Petter Nordahl-Hagen.
 * Derived from code by Markus Stephany under a compatible license:
 *   Copyright (c)2000-2004, Markus Stephany.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *)

type t
(** A [hive_h] hive file handle. *)

type node
type value
(** Nodes and values. *)

exception Error of string * Unix.error * string
(** Error raised by a function.

    The first parameter is the name of the function which raised the error.
    The second parameter is the errno (see the [Unix] module).  The third
    parameter is a human-readable string corresponding to the errno.

    See hivex(3) for a partial list of interesting errno values that
    can be generated by the library. *)
exception Handle_closed of string
(** This exception is raised if you call a function on a closed handle. *)

type hive_type =
  | REG_NONE (** Just a key without a value *)
  | REG_SZ (** A Windows string (encoding is unknown, but often UTF16-LE) *)
  | REG_EXPAND_SZ (** A Windows string that contains %env% (environment variable expansion) *)
  | REG_BINARY (** A blob of binary *)
  | REG_DWORD (** DWORD (32 bit integer), little endian *)
  | REG_DWORD_BIG_ENDIAN (** DWORD (32 bit integer), big endian *)
  | REG_LINK (** Symbolic link to another part of the registry tree *)
  | REG_MULTI_SZ (** Multiple Windows strings.  See http://blogs.msdn.com/oldnewthing/archive/2009/10/08/9904646.aspx *)
  | REG_RESOURCE_LIST (** Resource list *)
  | REG_FULL_RESOURCE_DESCRIPTOR (** Resource descriptor *)
  | REG_RESOURCE_REQUIREMENTS_LIST (** Resouce requirements list *)
  | REG_QWORD (** QWORD (64 bit integer), unspecified endianness but usually little endian *)
| REG_UNKNOWN of int32 (** unknown type *)
(** Hive type field. *)

type open_flag =
  | OPEN_VERBOSE (** Verbose messages *)
  | OPEN_DEBUG (** Debug messages *)
  | OPEN_WRITE (** Enable writes to the hive *)
  | OPEN_UNSAFE (** Enable heuristics to allow read/write of corrupted hives *)
(** Open flags for {!open_file} call. *)

type set_value = {
  key : string;
  t : hive_type;
  value : string;
}
(** (key, value) pair passed (as an array) to {!node_set_values}. *)

val open_file : string -> open_flag list -> t
(** open a hive file *)

val close : t -> unit
(** close a hive handle *)

val root : t -> node
(** return the root node of the hive *)

val last_modified : t -> int64
(** return the modification time from the header of the hive *)

val node_name : t -> node -> string
(** return the name of the node *)

val node_name_len : t -> node -> int64
(** return the length of a node's name *)

val node_timestamp : t -> node -> int64
(** return the modification time of the node *)

val node_children : t -> node -> node array
(** return children of node *)

val node_get_child : t -> node -> string -> node
(** return named child of node *)

val node_nr_children : t -> node -> int64
(** return the number of children of a node *)

val node_parent : t -> node -> node
(** return the parent of node *)

val node_values : t -> node -> value array
(** return (key, value) pairs attached to a node *)

val node_get_value : t -> node -> string -> value
(** return named key at node *)

val node_nr_values : t -> node -> int64
(** return the number of values attached to a node *)

val value_key_len : t -> value -> int64
(** return the length of a value's key *)

val value_key : t -> value -> string
(** return the key of a (key, value) pair *)

val value_type : t -> value -> hive_type * int
(** return data length and data type of a value *)

val node_struct_length : t -> node -> int64
(** return the length of a node *)

val value_struct_length : t -> value -> int64
(** return the length of a value data structure *)

val value_data_cell_offset : t -> value -> int * value
(** return the offset and length of a value data cell *)

val value_value : t -> value -> hive_type * string
(** return data length, data type and data of a value *)

val value_string : t -> value -> string
(** return value as a string *)

val value_multiple_strings : t -> value -> string array
(** return value as multiple strings *)

val value_dword : t -> value -> int32
(** return value as a DWORD *)

val value_qword : t -> value -> int64
(** return value as a QWORD *)

val commit : t -> string option -> unit
(** commit (write) changes to file *)

val node_add_child : t -> node -> string -> node
(** add child node *)

val node_delete_child : t -> node -> unit
(** delete child node *)

val node_set_values : t -> node -> set_value array -> unit
(** set (key, value) pairs at a node *)

val node_set_value : t -> node -> set_value -> unit
(** set a single (key, value) pair at a given node *)
