/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.SourceInfo;
import tim.prune.load.FileToBeLoaded;
import tim.prune.load.FileTypeLoader;
import tim.prune.load.MediaLinkInfo;
import tim.prune.load.xml.GpxHandler;
import tim.prune.load.xml.KmlHandler;
import tim.prune.load.xml.XmlHandler;

public class XmlFileLoader
extends DefaultHandler
implements Runnable {
    private final App _app;
    private FileToBeLoaded _fileLock = null;
    private boolean _autoAppend = false;
    private XmlHandler _handler = null;
    private String _unknownType = null;

    public XmlFileLoader(App app) {
        this._app = app;
    }

    public void reset() {
        this._handler = null;
        this._unknownType = null;
    }

    public void openFile(FileToBeLoaded fileToBeLoaded, boolean bl) {
        this._fileLock = fileToBeLoaded;
        this._fileLock.takeOwnership();
        this._autoAppend = bl;
        this.reset();
        new Thread(this).start();
    }

    @Override
    public void run() {
        FileInputStream fileInputStream = null;
        boolean bl = false;
        try {
            fileInputStream = new FileInputStream(this._fileLock.getFile());
            bl = this.parseXmlStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (bl) {
            if (this._handler == null) {
                this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(I18nManager.getText("error.load.unknownxml")) + " " + this._unknownType);
            } else {
                SourceInfo sourceInfo = new SourceInfo(this._fileLock.getFile(), this._handler.getFileType(), this._handler.getFileVersion());
                sourceInfo.setFileTitle(this._handler.getFileTitle());
                sourceInfo.setFileDescription(this._handler.getFileDescription());
                sourceInfo.setExtensionInfo(this._handler.getExtensionInfo());
                new FileTypeLoader(this._app).loadData(this._handler, sourceInfo, this._autoAppend, new MediaLinkInfo(this._handler.getLinkArray()));
            }
        }
        this._fileLock.release();
    }

    public boolean parseXmlStream(InputStream inputStream) {
        SAXParser sAXParser;
        boolean bl = false;
        try {
            sAXParser = SAXParserFactory.newInstance("org.apache.xerces.parsers.SAXParser", null).newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
            bl = true;
        }
        catch (Throwable throwable) {}
        if (!bl) {
            try {
                sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse(inputStream, (DefaultHandler)this);
                bl = true;
            }
            catch (Exception exception) {
                this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(I18nManager.getText("error.load.othererror")) + " " + exception.getMessage());
            }
        }
        return bl;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this._handler == null) {
            if (string3.equals("kml")) {
                this._handler = new KmlHandler();
            } else if (string3.equals("gpx")) {
                this._handler = new GpxHandler();
            } else if (this._unknownType == null && !string3.equals("")) {
                this._unknownType = string3;
            }
        }
        if (this._handler != null) {
            this._handler.startElement(string, string2, string3, attributes);
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._handler != null) {
            this._handler.characters(cArray, n, n2);
        }
        super.characters(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this._handler != null) {
            this._handler.endElement(string, string2, string3);
        }
        super.endElement(string, string2, string3);
    }

    public XmlHandler getHandler() {
        return this._handler;
    }
}

