/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.media;

import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.Command;
import tim.prune.cmd.CompoundCommand;
import tim.prune.cmd.ConnectMediaCmd;
import tim.prune.cmd.DeletePointCmd;
import tim.prune.cmd.RemoveAudioCmd;
import tim.prune.cmd.RemovePhotoCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Photo;
import tim.prune.function.media.PopupResponse;

public class RemovePhotoFunction
extends GenericFunction {
    public RemovePhotoFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.removephoto";
    }

    @Override
    public void begin() {
        Command command;
        Photo photo = this._app.getTrackInfo().getCurrentPhoto();
        if (photo == null) {
            return;
        }
        RemovePhotoCmd removePhotoCmd = new RemovePhotoCmd(this._app.getTrackInfo().getSelection().getCurrentPhotoIndex());
        DataPoint dataPoint = photo.getDataPoint();
        boolean bl = false;
        switch (this.shouldDeletePoint(photo)) {
            default: {
                return;
            }
            case MEDIA_NOT_CONNECTED: {
                command = removePhotoCmd;
                break;
            }
            case UNLINK: {
                command = new CompoundCommand().addCommand(removePhotoCmd).addCommand(new ConnectMediaCmd(dataPoint, null, dataPoint.getAudio()));
                bl = true;
                break;
            }
            case DELETE: {
                command = new CompoundCommand().addCommand(removePhotoCmd).addCommand(new DeletePointCmd(this._app.getTrackInfo().getSelection().getCurrentPointIndex())).addCommand(dataPoint == null || dataPoint.getPhoto() == null ? null : new RemoveAudioCmd(this._app.getTrackInfo().getSelection().getCurrentAudioIndex()));
            }
        }
        command.setDescription(I18nManager.getText("undo.removephoto", photo.getName()));
        command.setConfirmText(I18nManager.getText("confirm.media.removed", photo.getName()));
        this._app.execute(command);
        if (bl) {
            this._app.getTrackInfo().selectPhoto(-1);
        }
    }

    private PopupResponse shouldDeletePoint(Photo photo) {
        DataPoint dataPoint = photo.getDataPoint();
        if (dataPoint == null) {
            return PopupResponse.MEDIA_NOT_CONNECTED;
        }
        boolean bl = dataPoint.getAudio() != null;
        String string = bl ? I18nManager.getText("dialog.deletephoto.deletepointandaudio", dataPoint.getAudio().getName()) : I18nManager.getText("dialog.deletephoto.deletepoint");
        int n = JOptionPane.showConfirmDialog(this._app.getFrame(), string, I18nManager.getText("dialog.deletephoto.title"), 1);
        if (n == 2 || n == -1) {
            return PopupResponse.CANCEL;
        }
        return n == 0 ? PopupResponse.DELETE : PopupResponse.UNLINK;
    }
}

