/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import java.security.AccessControlException;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.ScaledEditorKit;
import org.freeplane.core.ui.components.html.SynchronousScaledEditorKit;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.map.LinkOpener;
import org.freeplane.view.swing.map.NodeView;

class TextualTooltipRendererFactory {
    private final JEditorPane tip;
    private int maximumWidth;
    private final String contentType;
    private final JRestrictedSizeScrollPane scrollPane;
    private final JComponent component;
    private final URL baseUrl;

    TextualTooltipRendererFactory(String contentType, URL baseUrl, String tipText, JComponent component, ComponentOrientation componentOrientation, Dimension tooltipSize, boolean honorDisplayProperties) {
        this.contentType = contentType;
        this.baseUrl = baseUrl;
        this.component = component;
        this.tip = new JEditorPane();
        this.tip.setContentType(contentType);
        this.tip.putClientProperty("JEditorPane.honorDisplayProperties", honorDisplayProperties);
        if (contentType.equals("text/html")) {
            ScaledEditorKit kit = SynchronousScaledEditorKit.create();
            this.tip.setEditorKit(kit);
            HTMLDocument document = (HTMLDocument)this.tip.getDocument();
            document.setPreservesUnknownTags(false);
            StyleSheet styleSheet = document.getStyleSheet();
            styleSheet.addRule("p {margin-top:0;}");
            styleSheet.addRule("table {border: 0; border-spacing: 0;}");
            styleSheet.addRule("th, td {border: 1px solid;}");
        }
        this.tip.setComponentOrientation(componentOrientation);
        this.tip.setEditable(false);
        this.tip.setMargin(new Insets(0, 0, 0, 0));
        LinkOpener linkOpener = new LinkOpener(this::getNode);
        this.tip.addMouseListener(linkOpener);
        this.tip.addMouseMotionListener(linkOpener);
        this.scrollPane = new JRestrictedSizeScrollPane(this.tip);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        int scrollBarWidth = this.scrollPane.getVerticalScrollBar().getPreferredSize().width;
        tooltipSize.width -= scrollBarWidth;
        this.scrollPane.setMaximumSize(tooltipSize);
        this.maximumWidth = tooltipSize.width;
        UITools.setScrollbarIncrement(this.scrollPane);
        this.tip.setOpaque(true);
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TextualTooltipRendererFactory.this.scrollUp();
                TextualTooltipRendererFactory.this.scrollPane.removeComponentListener(this);
            }
        });
        this.setTipText(tipText);
    }

    private NodeModel getNode() {
        NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this.component);
        return nodeView != null ? nodeView.getNode() : null;
    }

    private void setTipText(String tipText) {
        try {
            this.setTipTextUnsafe(tipText);
        }
        catch (Exception e1) {
            if (e1 instanceof AccessControlException) {
                LogUtils.warn(e1.getMessage());
            } else {
                LogUtils.severe(e1);
            }
            String localizedMessage = e1.getLocalizedMessage();
            String htmlEscapedText = HtmlUtils.plainToHTML(localizedMessage + '\n' + tipText);
            try {
                this.setTipTextUnsafe(htmlEscapedText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setTipTextUnsafe(String tipText) throws Exception {
        this.tip.setSize(0, 0);
        this.tip.setPreferredSize(null);
        this.tip.setText(tipText);
        ((HTMLDocument)this.tip.getDocument()).setBase(this.baseUrl);
        Dimension preferredSize = this.tip.getPreferredSize();
        if (preferredSize.width > this.maximumWidth && this.contentType.equals("text/html")) {
            HTMLDocument document = (HTMLDocument)this.tip.getDocument();
            document.getStyleSheet().addRule("body { width: " + this.maximumWidth + "}");
            this.tip.setEditable(true);
            this.tip.setEditable(false);
            preferredSize = this.tip.getPreferredSize();
            if (preferredSize.width > this.maximumWidth) {
                // empty if block
            }
        }
        this.tip.setSize(preferredSize);
        preferredSize = this.tip.getPreferredSize();
        this.tip.setPreferredSize(preferredSize);
    }

    JComponent getTooltipRenderer() {
        return this.scrollPane;
    }

    private void scrollUp() {
        this.tip.scrollRectToVisible(new Rectangle(1, 1));
    }
}

