
#ifndef VTKIOALEMBIC_EXPORT_H
#define VTKIOALEMBIC_EXPORT_H

#ifdef VTKIOALEMBIC_STATIC_DEFINE
#  define VTKIOALEMBIC_EXPORT
#  define VTKIOALEMBIC_NO_EXPORT
#else
#  ifndef VTKIOALEMBIC_EXPORT
#    ifdef IOAlembic_EXPORTS
        /* We are building this library */
#      define VTKIOALEMBIC_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define VTKIOALEMBIC_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef VTKIOALEMBIC_NO_EXPORT
#    define VTKIOALEMBIC_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef VTKIOALEMBIC_DEPRECATED
#  define VTKIOALEMBIC_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef VTKIOALEMBIC_DEPRECATED_EXPORT
#  define VTKIOALEMBIC_DEPRECATED_EXPORT VTKIOALEMBIC_EXPORT VTKIOALEMBIC_DEPRECATED
#endif

#ifndef VTKIOALEMBIC_DEPRECATED_NO_EXPORT
#  define VTKIOALEMBIC_DEPRECATED_NO_EXPORT VTKIOALEMBIC_NO_EXPORT VTKIOALEMBIC_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef VTKIOALEMBIC_NO_DEPRECATED
#    define VTKIOALEMBIC_NO_DEPRECATED
#  endif
#endif

/* VTK-HeaderTest-Exclude: vtkIOAlembicModule.h */

/* Include ABI Namespace */
#include "vtkABINamespace.h"

#endif /* VTKIOALEMBIC_EXPORT_H */
