# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AdditionalData(_serialization.Model):
    """Details of the sub-assessment.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContainerRegistryVulnerabilityProperties, ServerVulnerabilityProperties,
    SqlServerVulnerabilityProperties

    All required parameters must be populated in order to send to Azure.

    :ivar assessed_resource_type: Sub-assessment resource type. Required. Known values are:
     "SqlServerVulnerability", "ContainerRegistryVulnerability", and "ServerVulnerability".
    :vartype assessed_resource_type: str or
     ~azure.mgmt.security.v2019_01_01_preview.models.AssessedResourceType
    """

    _validation = {
        "assessed_resource_type": {"required": True},
    }

    _attribute_map = {
        "assessed_resource_type": {"key": "assessedResourceType", "type": "str"},
    }

    _subtype_map = {
        "assessed_resource_type": {
            "ContainerRegistryVulnerability": "ContainerRegistryVulnerabilityProperties",
            "ServerVulnerabilityAssessment": "ServerVulnerabilityProperties",
            "SqlServerVulnerability": "SqlServerVulnerabilityProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessed_resource_type: Optional[str] = None


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AlertsSuppressionRule(Resource):
    """Describes the suppression rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar alert_type: Type of the alert to automatically suppress. For all alert types, use '*'.
    :vartype alert_type: str
    :ivar last_modified_utc: The last time this rule was modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar expiration_date_utc: Expiration date of the rule, if value is not provided or provided as
     null there will no expiration at all.
    :vartype expiration_date_utc: ~datetime.datetime
    :ivar reason: The reason for dismissing the alert.
    :vartype reason: str
    :ivar state: Possible states of the rule. Known values are: "Enabled", "Disabled", and
     "Expired".
    :vartype state: str or ~azure.mgmt.security.v2019_01_01_preview.models.RuleState
    :ivar comment: Any comment regarding the rule.
    :vartype comment: str
    :ivar suppression_alerts_scope: The suppression conditions.
    :vartype suppression_alerts_scope:
     ~azure.mgmt.security.v2019_01_01_preview.models.SuppressionAlertsScope
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_modified_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "alert_type": {"key": "properties.alertType", "type": "str"},
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
        "expiration_date_utc": {"key": "properties.expirationDateUtc", "type": "iso-8601"},
        "reason": {"key": "properties.reason", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "comment": {"key": "properties.comment", "type": "str"},
        "suppression_alerts_scope": {"key": "properties.suppressionAlertsScope", "type": "SuppressionAlertsScope"},
    }

    def __init__(
        self,
        *,
        alert_type: Optional[str] = None,
        expiration_date_utc: Optional[datetime.datetime] = None,
        reason: Optional[str] = None,
        state: Optional[Union[str, "_models.RuleState"]] = None,
        comment: Optional[str] = None,
        suppression_alerts_scope: Optional["_models.SuppressionAlertsScope"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword alert_type: Type of the alert to automatically suppress. For all alert types, use '*'.
        :paramtype alert_type: str
        :keyword expiration_date_utc: Expiration date of the rule, if value is not provided or provided
         as null there will no expiration at all.
        :paramtype expiration_date_utc: ~datetime.datetime
        :keyword reason: The reason for dismissing the alert.
        :paramtype reason: str
        :keyword state: Possible states of the rule. Known values are: "Enabled", "Disabled", and
         "Expired".
        :paramtype state: str or ~azure.mgmt.security.v2019_01_01_preview.models.RuleState
        :keyword comment: Any comment regarding the rule.
        :paramtype comment: str
        :keyword suppression_alerts_scope: The suppression conditions.
        :paramtype suppression_alerts_scope:
         ~azure.mgmt.security.v2019_01_01_preview.models.SuppressionAlertsScope
        """
        super().__init__(**kwargs)
        self.alert_type = alert_type
        self.last_modified_utc = None
        self.expiration_date_utc = expiration_date_utc
        self.reason = reason
        self.state = state
        self.comment = comment
        self.suppression_alerts_scope = suppression_alerts_scope


class AlertsSuppressionRulesList(_serialization.Model):
    """Suppression rules list for subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.security.v2019_01_01_preview.models.AlertsSuppressionRule]
    :ivar next_link: URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AlertsSuppressionRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AlertsSuppressionRule"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.security.v2019_01_01_preview.models.AlertsSuppressionRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Tags(_serialization.Model):
    """A list of key value pairs that describe the resource.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ETag(_serialization.Model):
    """Entity tag is used for comparing two or more entities from the same requested resource.

    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    """

    _attribute_map = {
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.etag = etag


class Kind(_serialization.Model):
    """Describes an Azure resource with kind.

    :ivar kind: Kind of the resource.
    :vartype kind: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.kind = kind


class AzureTrackedResourceLocation(_serialization.Model):
    """Describes an Azure resource with location.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location


class TrackedResource(Resource, AzureTrackedResourceLocation, Kind, ETag, Tags):
    """Describes an Azure tracked resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        """
        super().__init__(location=location, kind=kind, etag=etag, tags=tags, **kwargs)
        self.tags = tags
        self.etag = etag
        self.kind = kind
        self.location = location
        self.id = None
        self.name = None
        self.type = None


class Automation(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The security automation resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: The security automation description.
    :vartype description: str
    :ivar is_enabled: Indicates whether the security automation is enabled.
    :vartype is_enabled: bool
    :ivar scopes: A collection of scopes on which the security automations logic is applied.
     Supported scopes are the subscription itself or a resource group under that subscription. The
     automation will only apply on defined scopes.
    :vartype scopes: list[~azure.mgmt.security.v2019_01_01_preview.models.AutomationScope]
    :ivar sources: A collection of the source event types which evaluate the security automation
     set of rules.
    :vartype sources: list[~azure.mgmt.security.v2019_01_01_preview.models.AutomationSource]
    :ivar actions: A collection of the actions which are triggered if all the configured rules
     evaluations, within at least one rule set, are true.
    :vartype actions: list[~azure.mgmt.security.v2019_01_01_preview.models.AutomationAction]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "scopes": {"key": "properties.scopes", "type": "[AutomationScope]"},
        "sources": {"key": "properties.sources", "type": "[AutomationSource]"},
        "actions": {"key": "properties.actions", "type": "[AutomationAction]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        description: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        scopes: Optional[List["_models.AutomationScope"]] = None,
        sources: Optional[List["_models.AutomationSource"]] = None,
        actions: Optional[List["_models.AutomationAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        :keyword description: The security automation description.
        :paramtype description: str
        :keyword is_enabled: Indicates whether the security automation is enabled.
        :paramtype is_enabled: bool
        :keyword scopes: A collection of scopes on which the security automations logic is applied.
         Supported scopes are the subscription itself or a resource group under that subscription. The
         automation will only apply on defined scopes.
        :paramtype scopes: list[~azure.mgmt.security.v2019_01_01_preview.models.AutomationScope]
        :keyword sources: A collection of the source event types which evaluate the security automation
         set of rules.
        :paramtype sources: list[~azure.mgmt.security.v2019_01_01_preview.models.AutomationSource]
        :keyword actions: A collection of the actions which are triggered if all the configured rules
         evaluations, within at least one rule set, are true.
        :paramtype actions: list[~azure.mgmt.security.v2019_01_01_preview.models.AutomationAction]
        """
        super().__init__(tags=tags, etag=etag, kind=kind, location=location, **kwargs)
        self.description = description
        self.is_enabled = is_enabled
        self.scopes = scopes
        self.sources = sources
        self.actions = actions


class AutomationAction(_serialization.Model):
    """The action that should be triggered.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutomationActionEventHub, AutomationActionLogicApp, AutomationActionWorkspace

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: The type of the action that will be triggered by the Automation. Required.
     Known values are: "LogicApp", "EventHub", and "Workspace".
    :vartype action_type: str or ~azure.mgmt.security.v2019_01_01_preview.models.ActionType
    """

    _validation = {
        "action_type": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
    }

    _subtype_map = {
        "action_type": {
            "EventHub": "AutomationActionEventHub",
            "LogicApp": "AutomationActionLogicApp",
            "Workspace": "AutomationActionWorkspace",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.action_type: Optional[str] = None


class AutomationActionEventHub(AutomationAction):
    """The target Event Hub to which event data will be exported. To learn more about Microsoft
    Defender for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: The type of the action that will be triggered by the Automation. Required.
     Known values are: "LogicApp", "EventHub", and "Workspace".
    :vartype action_type: str or ~azure.mgmt.security.v2019_01_01_preview.models.ActionType
    :ivar event_hub_resource_id: The target Event Hub Azure Resource ID.
    :vartype event_hub_resource_id: str
    :ivar sas_policy_name: The target Event Hub SAS policy name.
    :vartype sas_policy_name: str
    :ivar connection_string: The target Event Hub connection string (it will not be included in any
     response).
    :vartype connection_string: str
    """

    _validation = {
        "action_type": {"required": True},
        "sas_policy_name": {"readonly": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "event_hub_resource_id": {"key": "eventHubResourceId", "type": "str"},
        "sas_policy_name": {"key": "sasPolicyName", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
    }

    def __init__(
        self, *, event_hub_resource_id: Optional[str] = None, connection_string: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword event_hub_resource_id: The target Event Hub Azure Resource ID.
        :paramtype event_hub_resource_id: str
        :keyword connection_string: The target Event Hub connection string (it will not be included in
         any response).
        :paramtype connection_string: str
        """
        super().__init__(**kwargs)
        self.action_type: str = "EventHub"
        self.event_hub_resource_id = event_hub_resource_id
        self.sas_policy_name = None
        self.connection_string = connection_string


class AutomationActionLogicApp(AutomationAction):
    """The logic app action that should be triggered. To learn more about Microsoft Defender for
    Cloud's Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: The type of the action that will be triggered by the Automation. Required.
     Known values are: "LogicApp", "EventHub", and "Workspace".
    :vartype action_type: str or ~azure.mgmt.security.v2019_01_01_preview.models.ActionType
    :ivar logic_app_resource_id: The triggered Logic App Azure Resource ID. This can also reside on
     other subscriptions, given that you have permissions to trigger the Logic App.
    :vartype logic_app_resource_id: str
    :ivar uri: The Logic App trigger URI endpoint (it will not be included in any response).
    :vartype uri: str
    """

    _validation = {
        "action_type": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "logic_app_resource_id": {"key": "logicAppResourceId", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self, *, logic_app_resource_id: Optional[str] = None, uri: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword logic_app_resource_id: The triggered Logic App Azure Resource ID. This can also reside
         on other subscriptions, given that you have permissions to trigger the Logic App.
        :paramtype logic_app_resource_id: str
        :keyword uri: The Logic App trigger URI endpoint (it will not be included in any response).
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.action_type: str = "LogicApp"
        self.logic_app_resource_id = logic_app_resource_id
        self.uri = uri


class AutomationActionWorkspace(AutomationAction):
    """The Log Analytics Workspace to which event data will be exported. Security alerts data will
    reside in the 'SecurityAlert' table and the assessments data will reside in the
    'SecurityRecommendation' table (under the 'Security'/'SecurityCenterFree' solutions). Note that
    in order to view the data in the workspace, the Security Center Log Analytics free/standard
    solution needs to be enabled on that workspace. To learn more about Microsoft Defender for
    Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: The type of the action that will be triggered by the Automation. Required.
     Known values are: "LogicApp", "EventHub", and "Workspace".
    :vartype action_type: str or ~azure.mgmt.security.v2019_01_01_preview.models.ActionType
    :ivar workspace_resource_id: The fully qualified Log Analytics Workspace Azure Resource ID.
    :vartype workspace_resource_id: str
    """

    _validation = {
        "action_type": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "workspace_resource_id": {"key": "workspaceResourceId", "type": "str"},
    }

    def __init__(self, *, workspace_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword workspace_resource_id: The fully qualified Log Analytics Workspace Azure Resource ID.
        :paramtype workspace_resource_id: str
        """
        super().__init__(**kwargs)
        self.action_type: str = "Workspace"
        self.workspace_resource_id = workspace_resource_id


class AutomationList(_serialization.Model):
    """List of security automations response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of security automations under the given scope. Required.
    :vartype value: list[~azure.mgmt.security.v2019_01_01_preview.models.Automation]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Automation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Automation"], **kwargs: Any) -> None:
        """
        :keyword value: The list of security automations under the given scope. Required.
        :paramtype value: list[~azure.mgmt.security.v2019_01_01_preview.models.Automation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AutomationRuleSet(_serialization.Model):
    """A rule set which evaluates all its rules upon an event interception. Only when all the included
    rules in the rule set will be evaluated as 'true', will the event trigger the defined actions.

    :ivar rules:
    :vartype rules: list[~azure.mgmt.security.v2019_01_01_preview.models.AutomationTriggeringRule]
    """

    _attribute_map = {
        "rules": {"key": "rules", "type": "[AutomationTriggeringRule]"},
    }

    def __init__(self, *, rules: Optional[List["_models.AutomationTriggeringRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword rules:
        :paramtype rules:
         list[~azure.mgmt.security.v2019_01_01_preview.models.AutomationTriggeringRule]
        """
        super().__init__(**kwargs)
        self.rules = rules


class AutomationScope(_serialization.Model):
    """A single automation scope.

    :ivar description: The resources scope description.
    :vartype description: str
    :ivar scope_path: The resources scope path. Can be the subscription on which the automation is
     defined on or a resource group under that subscription (fully qualified Azure resource IDs).
    :vartype scope_path: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "scope_path": {"key": "scopePath", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, scope_path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: The resources scope description.
        :paramtype description: str
        :keyword scope_path: The resources scope path. Can be the subscription on which the automation
         is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
        :paramtype scope_path: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.scope_path = scope_path


class AutomationSource(_serialization.Model):
    """The source event types which evaluate the security automation set of rules. For example -
    security alerts and security assessments. To learn more about the supported security events
    data models schemas - please visit https://aka.ms/ASCAutomationSchemas.

    :ivar event_source: A valid event source type. Known values are: "Assessments",
     "AssessmentsSnapshot", "SubAssessments", "SubAssessmentsSnapshot", "Alerts", "SecureScores",
     "SecureScoresSnapshot", "SecureScoreControls", "SecureScoreControlsSnapshot",
     "RegulatoryComplianceAssessment", and "RegulatoryComplianceAssessmentSnapshot".
    :vartype event_source: str or ~azure.mgmt.security.v2019_01_01_preview.models.EventSource
    :ivar rule_sets: A set of rules which evaluate upon event interception. A logical disjunction
     is applied between defined rule sets (logical 'or').
    :vartype rule_sets: list[~azure.mgmt.security.v2019_01_01_preview.models.AutomationRuleSet]
    """

    _attribute_map = {
        "event_source": {"key": "eventSource", "type": "str"},
        "rule_sets": {"key": "ruleSets", "type": "[AutomationRuleSet]"},
    }

    def __init__(
        self,
        *,
        event_source: Optional[Union[str, "_models.EventSource"]] = None,
        rule_sets: Optional[List["_models.AutomationRuleSet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword event_source: A valid event source type. Known values are: "Assessments",
         "AssessmentsSnapshot", "SubAssessments", "SubAssessmentsSnapshot", "Alerts", "SecureScores",
         "SecureScoresSnapshot", "SecureScoreControls", "SecureScoreControlsSnapshot",
         "RegulatoryComplianceAssessment", and "RegulatoryComplianceAssessmentSnapshot".
        :paramtype event_source: str or ~azure.mgmt.security.v2019_01_01_preview.models.EventSource
        :keyword rule_sets: A set of rules which evaluate upon event interception. A logical
         disjunction is applied between defined rule sets (logical 'or').
        :paramtype rule_sets: list[~azure.mgmt.security.v2019_01_01_preview.models.AutomationRuleSet]
        """
        super().__init__(**kwargs)
        self.event_source = event_source
        self.rule_sets = rule_sets


class AutomationTriggeringRule(_serialization.Model):
    """A rule which is evaluated upon event interception. The rule is configured by comparing a
    specific value from the event model to an expected value. This comparison is done by using one
    of the supported operators set.

    :ivar property_j_path: The JPath of the entity model property that should be checked.
    :vartype property_j_path: str
    :ivar property_type: The data type of the compared operands (string, integer, floating point
     number or a boolean [true/false]]. Known values are: "String", "Integer", "Number", and
     "Boolean".
    :vartype property_type: str or ~azure.mgmt.security.v2019_01_01_preview.models.PropertyType
    :ivar expected_value: The expected value.
    :vartype expected_value: str
    :ivar operator: A valid comparer operator to use. A case-insensitive comparison will be applied
     for String PropertyType. Known values are: "Equals", "GreaterThan", "GreaterThanOrEqualTo",
     "LesserThan", "LesserThanOrEqualTo", "NotEquals", "Contains", "StartsWith", and "EndsWith".
    :vartype operator: str or ~azure.mgmt.security.v2019_01_01_preview.models.Operator
    """

    _attribute_map = {
        "property_j_path": {"key": "propertyJPath", "type": "str"},
        "property_type": {"key": "propertyType", "type": "str"},
        "expected_value": {"key": "expectedValue", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
    }

    def __init__(
        self,
        *,
        property_j_path: Optional[str] = None,
        property_type: Optional[Union[str, "_models.PropertyType"]] = None,
        expected_value: Optional[str] = None,
        operator: Optional[Union[str, "_models.Operator"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword property_j_path: The JPath of the entity model property that should be checked.
        :paramtype property_j_path: str
        :keyword property_type: The data type of the compared operands (string, integer, floating point
         number or a boolean [true/false]]. Known values are: "String", "Integer", "Number", and
         "Boolean".
        :paramtype property_type: str or ~azure.mgmt.security.v2019_01_01_preview.models.PropertyType
        :keyword expected_value: The expected value.
        :paramtype expected_value: str
        :keyword operator: A valid comparer operator to use. A case-insensitive comparison will be
         applied for String PropertyType. Known values are: "Equals", "GreaterThan",
         "GreaterThanOrEqualTo", "LesserThan", "LesserThanOrEqualTo", "NotEquals", "Contains",
         "StartsWith", and "EndsWith".
        :paramtype operator: str or ~azure.mgmt.security.v2019_01_01_preview.models.Operator
        """
        super().__init__(**kwargs)
        self.property_j_path = property_j_path
        self.property_type = property_type
        self.expected_value = expected_value
        self.operator = operator


class AutomationValidationStatus(_serialization.Model):
    """The security automation model state property bag.

    :ivar is_valid: Indicates whether the model is valid or not.
    :vartype is_valid: bool
    :ivar message: The validation message.
    :vartype message: str
    """

    _attribute_map = {
        "is_valid": {"key": "isValid", "type": "bool"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, is_valid: Optional[bool] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword is_valid: Indicates whether the model is valid or not.
        :paramtype is_valid: bool
        :keyword message: The validation message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.is_valid = is_valid
        self.message = message


class ResourceDetails(_serialization.Model):
    """Details of the resource that was assessed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureResourceDetails, OnPremiseResourceDetails

    All required parameters must be populated in order to send to Azure.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2019_01_01_preview.models.Source
    """

    _validation = {
        "source": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
    }

    _subtype_map = {"source": {"Azure": "AzureResourceDetails", "OnPremise": "OnPremiseResourceDetails"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source: Optional[str] = None


class AzureResourceDetails(ResourceDetails):
    """Details of the Azure resource that was assessed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2019_01_01_preview.models.Source
    :ivar id: Azure resource Id of the assessed resource.
    :vartype id: str
    """

    _validation = {
        "source": {"required": True},
        "id": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source: str = "Azure"
        self.id = None


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2019_01_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2019_01_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ContainerRegistryVulnerabilityProperties(AdditionalData):
    """Additional context fields for container registry Vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar assessed_resource_type: Sub-assessment resource type. Required. Known values are:
     "SqlServerVulnerability", "ContainerRegistryVulnerability", and "ServerVulnerability".
    :vartype assessed_resource_type: str or
     ~azure.mgmt.security.v2019_01_01_preview.models.AssessedResourceType
    :ivar type: Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information
     Gathered, Vulnerability.
    :vartype type: str
    :ivar cvss: Dictionary from cvss version to cvss details object.
    :vartype cvss: dict[str, ~azure.mgmt.security.v2019_01_01_preview.models.CVSS]
    :ivar patchable: Indicates whether a patch is available or not.
    :vartype patchable: bool
    :ivar cve: List of CVEs.
    :vartype cve: list[~azure.mgmt.security.v2019_01_01_preview.models.CVE]
    :ivar published_time: Published time.
    :vartype published_time: ~datetime.datetime
    :ivar vendor_references:
    :vartype vendor_references:
     list[~azure.mgmt.security.v2019_01_01_preview.models.VendorReference]
    :ivar repository_name: Name of the repository which the vulnerable image belongs to.
    :vartype repository_name: str
    :ivar image_digest: Digest of the vulnerable image.
    :vartype image_digest: str
    """

    _validation = {
        "assessed_resource_type": {"required": True},
        "type": {"readonly": True},
        "cvss": {"readonly": True},
        "patchable": {"readonly": True},
        "cve": {"readonly": True},
        "published_time": {"readonly": True},
        "vendor_references": {"readonly": True},
        "repository_name": {"readonly": True},
        "image_digest": {"readonly": True},
    }

    _attribute_map = {
        "assessed_resource_type": {"key": "assessedResourceType", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "cvss": {"key": "cvss", "type": "{CVSS}"},
        "patchable": {"key": "patchable", "type": "bool"},
        "cve": {"key": "cve", "type": "[CVE]"},
        "published_time": {"key": "publishedTime", "type": "iso-8601"},
        "vendor_references": {"key": "vendorReferences", "type": "[VendorReference]"},
        "repository_name": {"key": "repositoryName", "type": "str"},
        "image_digest": {"key": "imageDigest", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessed_resource_type: str = "ContainerRegistryVulnerability"
        self.type = None
        self.cvss = None
        self.patchable = None
        self.cve = None
        self.published_time = None
        self.vendor_references = None
        self.repository_name = None
        self.image_digest = None


class CVE(_serialization.Model):
    """CVE details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar title: CVE title.
    :vartype title: str
    :ivar link: Link url.
    :vartype link: str
    """

    _validation = {
        "title": {"readonly": True},
        "link": {"readonly": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "link": {"key": "link", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.title = None
        self.link = None


class CVSS(_serialization.Model):
    """CVSS details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar base: CVSS base.
    :vartype base: float
    """

    _validation = {
        "base": {"readonly": True},
    }

    _attribute_map = {
        "base": {"key": "base", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.base = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class OnPremiseResourceDetails(ResourceDetails):
    """Details of the On Premise resource that was assessed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    OnPremiseSqlResourceDetails

    All required parameters must be populated in order to send to Azure.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2019_01_01_preview.models.Source
    :ivar workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
    :vartype workspace_id: str
    :ivar vmuuid: The unique Id of the machine. Required.
    :vartype vmuuid: str
    :ivar source_computer_id: The oms agent Id installed on the machine. Required.
    :vartype source_computer_id: str
    :ivar machine_name: The name of the machine. Required.
    :vartype machine_name: str
    """

    _validation = {
        "source": {"required": True},
        "workspace_id": {"required": True},
        "vmuuid": {"required": True},
        "source_computer_id": {"required": True},
        "machine_name": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "vmuuid": {"key": "vmuuid", "type": "str"},
        "source_computer_id": {"key": "sourceComputerId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
    }

    _subtype_map = {"source": {"OnPremiseSql": "OnPremiseSqlResourceDetails"}}

    def __init__(
        self, *, workspace_id: str, vmuuid: str, source_computer_id: str, machine_name: str, **kwargs: Any
    ) -> None:
        """
        :keyword workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
        :paramtype workspace_id: str
        :keyword vmuuid: The unique Id of the machine. Required.
        :paramtype vmuuid: str
        :keyword source_computer_id: The oms agent Id installed on the machine. Required.
        :paramtype source_computer_id: str
        :keyword machine_name: The name of the machine. Required.
        :paramtype machine_name: str
        """
        super().__init__(**kwargs)
        self.source: str = "OnPremise"
        self.workspace_id = workspace_id
        self.vmuuid = vmuuid
        self.source_computer_id = source_computer_id
        self.machine_name = machine_name


class OnPremiseSqlResourceDetails(OnPremiseResourceDetails):
    """Details of the On Premise Sql resource that was assessed.

    All required parameters must be populated in order to send to Azure.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2019_01_01_preview.models.Source
    :ivar workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
    :vartype workspace_id: str
    :ivar vmuuid: The unique Id of the machine. Required.
    :vartype vmuuid: str
    :ivar source_computer_id: The oms agent Id installed on the machine. Required.
    :vartype source_computer_id: str
    :ivar machine_name: The name of the machine. Required.
    :vartype machine_name: str
    :ivar server_name: The Sql server name installed on the machine. Required.
    :vartype server_name: str
    :ivar database_name: The Sql database name installed on the machine. Required.
    :vartype database_name: str
    """

    _validation = {
        "source": {"required": True},
        "workspace_id": {"required": True},
        "vmuuid": {"required": True},
        "source_computer_id": {"required": True},
        "machine_name": {"required": True},
        "server_name": {"required": True},
        "database_name": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "vmuuid": {"key": "vmuuid", "type": "str"},
        "source_computer_id": {"key": "sourceComputerId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
    }

    def __init__(
        self,
        *,
        workspace_id: str,
        vmuuid: str,
        source_computer_id: str,
        machine_name: str,
        server_name: str,
        database_name: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
        :paramtype workspace_id: str
        :keyword vmuuid: The unique Id of the machine. Required.
        :paramtype vmuuid: str
        :keyword source_computer_id: The oms agent Id installed on the machine. Required.
        :paramtype source_computer_id: str
        :keyword machine_name: The name of the machine. Required.
        :paramtype machine_name: str
        :keyword server_name: The Sql server name installed on the machine. Required.
        :paramtype server_name: str
        :keyword database_name: The Sql database name installed on the machine. Required.
        :paramtype database_name: str
        """
        super().__init__(
            workspace_id=workspace_id,
            vmuuid=vmuuid,
            source_computer_id=source_computer_id,
            machine_name=machine_name,
            **kwargs
        )
        self.source: str = "OnPremiseSql"
        self.server_name = server_name
        self.database_name = database_name


class RegulatoryComplianceAssessment(Resource):  # pylint: disable=too-many-instance-attributes
    """Regulatory compliance assessment details and state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: The description of the regulatory compliance assessment.
    :vartype description: str
    :ivar assessment_type: The expected type of assessment contained in the AssessmentDetailsLink.
    :vartype assessment_type: str
    :ivar assessment_details_link: Link to more detailed assessment results data. The response type
     will be according to the assessmentType field.
    :vartype assessment_details_link: str
    :ivar state: Aggregative state based on the assessment's scanned resources states. Known values
     are: "Passed", "Failed", "Skipped", and "Unsupported".
    :vartype state: str or ~azure.mgmt.security.v2019_01_01_preview.models.State
    :ivar passed_resources: The given assessment's related resources count with passed state.
    :vartype passed_resources: int
    :ivar failed_resources: The given assessment's related resources count with failed state.
    :vartype failed_resources: int
    :ivar skipped_resources: The given assessment's related resources count with skipped state.
    :vartype skipped_resources: int
    :ivar unsupported_resources: The given assessment's related resources count with unsupported
     state.
    :vartype unsupported_resources: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
        "assessment_type": {"readonly": True},
        "assessment_details_link": {"readonly": True},
        "passed_resources": {"readonly": True},
        "failed_resources": {"readonly": True},
        "skipped_resources": {"readonly": True},
        "unsupported_resources": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "assessment_type": {"key": "properties.assessmentType", "type": "str"},
        "assessment_details_link": {"key": "properties.assessmentDetailsLink", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "passed_resources": {"key": "properties.passedResources", "type": "int"},
        "failed_resources": {"key": "properties.failedResources", "type": "int"},
        "skipped_resources": {"key": "properties.skippedResources", "type": "int"},
        "unsupported_resources": {"key": "properties.unsupportedResources", "type": "int"},
    }

    def __init__(self, *, state: Optional[Union[str, "_models.State"]] = None, **kwargs: Any) -> None:
        """
        :keyword state: Aggregative state based on the assessment's scanned resources states. Known
         values are: "Passed", "Failed", "Skipped", and "Unsupported".
        :paramtype state: str or ~azure.mgmt.security.v2019_01_01_preview.models.State
        """
        super().__init__(**kwargs)
        self.description = None
        self.assessment_type = None
        self.assessment_details_link = None
        self.state = state
        self.passed_resources = None
        self.failed_resources = None
        self.skipped_resources = None
        self.unsupported_resources = None


class RegulatoryComplianceAssessmentList(_serialization.Model):
    """List of regulatory compliance assessment response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value:
     list[~azure.mgmt.security.v2019_01_01_preview.models.RegulatoryComplianceAssessment]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RegulatoryComplianceAssessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RegulatoryComplianceAssessment"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value:
         list[~azure.mgmt.security.v2019_01_01_preview.models.RegulatoryComplianceAssessment]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RegulatoryComplianceControl(Resource):
    """Regulatory compliance control details and state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: The description of the regulatory compliance control.
    :vartype description: str
    :ivar state: Aggregative state based on the control's supported assessments states. Known
     values are: "Passed", "Failed", "Skipped", and "Unsupported".
    :vartype state: str or ~azure.mgmt.security.v2019_01_01_preview.models.State
    :ivar passed_assessments: The number of supported regulatory compliance assessments of the
     given control with a passed state.
    :vartype passed_assessments: int
    :ivar failed_assessments: The number of supported regulatory compliance assessments of the
     given control with a failed state.
    :vartype failed_assessments: int
    :ivar skipped_assessments: The number of supported regulatory compliance assessments of the
     given control with a skipped state.
    :vartype skipped_assessments: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
        "passed_assessments": {"readonly": True},
        "failed_assessments": {"readonly": True},
        "skipped_assessments": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "passed_assessments": {"key": "properties.passedAssessments", "type": "int"},
        "failed_assessments": {"key": "properties.failedAssessments", "type": "int"},
        "skipped_assessments": {"key": "properties.skippedAssessments", "type": "int"},
    }

    def __init__(self, *, state: Optional[Union[str, "_models.State"]] = None, **kwargs: Any) -> None:
        """
        :keyword state: Aggregative state based on the control's supported assessments states. Known
         values are: "Passed", "Failed", "Skipped", and "Unsupported".
        :paramtype state: str or ~azure.mgmt.security.v2019_01_01_preview.models.State
        """
        super().__init__(**kwargs)
        self.description = None
        self.state = state
        self.passed_assessments = None
        self.failed_assessments = None
        self.skipped_assessments = None


class RegulatoryComplianceControlList(_serialization.Model):
    """List of regulatory compliance controls response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of regulatory compliance controls. Required.
    :vartype value:
     list[~azure.mgmt.security.v2019_01_01_preview.models.RegulatoryComplianceControl]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RegulatoryComplianceControl]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RegulatoryComplianceControl"], **kwargs: Any) -> None:
        """
        :keyword value: List of regulatory compliance controls. Required.
        :paramtype value:
         list[~azure.mgmt.security.v2019_01_01_preview.models.RegulatoryComplianceControl]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RegulatoryComplianceStandard(Resource):
    """Regulatory compliance standard details and state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: Aggregative state based on the standard's supported controls states. Known values
     are: "Passed", "Failed", "Skipped", and "Unsupported".
    :vartype state: str or ~azure.mgmt.security.v2019_01_01_preview.models.State
    :ivar passed_controls: The number of supported regulatory compliance controls of the given
     standard with a passed state.
    :vartype passed_controls: int
    :ivar failed_controls: The number of supported regulatory compliance controls of the given
     standard with a failed state.
    :vartype failed_controls: int
    :ivar skipped_controls: The number of supported regulatory compliance controls of the given
     standard with a skipped state.
    :vartype skipped_controls: int
    :ivar unsupported_controls: The number of regulatory compliance controls of the given standard
     which are unsupported by automated assessments.
    :vartype unsupported_controls: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "passed_controls": {"readonly": True},
        "failed_controls": {"readonly": True},
        "skipped_controls": {"readonly": True},
        "unsupported_controls": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "passed_controls": {"key": "properties.passedControls", "type": "int"},
        "failed_controls": {"key": "properties.failedControls", "type": "int"},
        "skipped_controls": {"key": "properties.skippedControls", "type": "int"},
        "unsupported_controls": {"key": "properties.unsupportedControls", "type": "int"},
    }

    def __init__(self, *, state: Optional[Union[str, "_models.State"]] = None, **kwargs: Any) -> None:
        """
        :keyword state: Aggregative state based on the standard's supported controls states. Known
         values are: "Passed", "Failed", "Skipped", and "Unsupported".
        :paramtype state: str or ~azure.mgmt.security.v2019_01_01_preview.models.State
        """
        super().__init__(**kwargs)
        self.state = state
        self.passed_controls = None
        self.failed_controls = None
        self.skipped_controls = None
        self.unsupported_controls = None


class RegulatoryComplianceStandardList(_serialization.Model):
    """List of regulatory compliance standards response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value:
     list[~azure.mgmt.security.v2019_01_01_preview.models.RegulatoryComplianceStandard]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RegulatoryComplianceStandard]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RegulatoryComplianceStandard"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value:
         list[~azure.mgmt.security.v2019_01_01_preview.models.RegulatoryComplianceStandard]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ScopeElement(_serialization.Model):
    """A more specific scope used to identify the alerts to suppress.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar field: The alert entity type to suppress by.
    :vartype field: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "field": {"key": "field", "type": "str"},
    }

    def __init__(
        self, *, additional_properties: Optional[Dict[str, Any]] = None, field: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword field: The alert entity type to suppress by.
        :paramtype field: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.field = field


class SecuritySubAssessment(Resource):  # pylint: disable=too-many-instance-attributes
    """Security sub-assessment on a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id_properties_id: Vulnerability ID.
    :vartype id_properties_id: str
    :ivar display_name: User friendly display name of the sub-assessment.
    :vartype display_name: str
    :ivar status: Status of the sub-assessment.
    :vartype status: ~azure.mgmt.security.v2019_01_01_preview.models.SubAssessmentStatus
    :ivar remediation: Information on how to remediate this sub-assessment.
    :vartype remediation: str
    :ivar impact: Description of the impact of this sub-assessment.
    :vartype impact: str
    :ivar category: Category of the sub-assessment.
    :vartype category: str
    :ivar description: Human readable description of the assessment status.
    :vartype description: str
    :ivar time_generated: The date and time the sub-assessment was generated.
    :vartype time_generated: ~datetime.datetime
    :ivar resource_details: Details of the resource that was assessed.
    :vartype resource_details: ~azure.mgmt.security.v2019_01_01_preview.models.ResourceDetails
    :ivar additional_data: Details of the sub-assessment.
    :vartype additional_data: ~azure.mgmt.security.v2019_01_01_preview.models.AdditionalData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "id_properties_id": {"readonly": True},
        "display_name": {"readonly": True},
        "remediation": {"readonly": True},
        "impact": {"readonly": True},
        "category": {"readonly": True},
        "description": {"readonly": True},
        "time_generated": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "id_properties_id": {"key": "properties.id", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "status": {"key": "properties.status", "type": "SubAssessmentStatus"},
        "remediation": {"key": "properties.remediation", "type": "str"},
        "impact": {"key": "properties.impact", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "time_generated": {"key": "properties.timeGenerated", "type": "iso-8601"},
        "resource_details": {"key": "properties.resourceDetails", "type": "ResourceDetails"},
        "additional_data": {"key": "properties.additionalData", "type": "AdditionalData"},
    }

    def __init__(
        self,
        *,
        status: Optional["_models.SubAssessmentStatus"] = None,
        resource_details: Optional["_models.ResourceDetails"] = None,
        additional_data: Optional["_models.AdditionalData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the sub-assessment.
        :paramtype status: ~azure.mgmt.security.v2019_01_01_preview.models.SubAssessmentStatus
        :keyword resource_details: Details of the resource that was assessed.
        :paramtype resource_details: ~azure.mgmt.security.v2019_01_01_preview.models.ResourceDetails
        :keyword additional_data: Details of the sub-assessment.
        :paramtype additional_data: ~azure.mgmt.security.v2019_01_01_preview.models.AdditionalData
        """
        super().__init__(**kwargs)
        self.id_properties_id = None
        self.display_name = None
        self.status = status
        self.remediation = None
        self.impact = None
        self.category = None
        self.description = None
        self.time_generated = None
        self.resource_details = resource_details
        self.additional_data = additional_data


class SecuritySubAssessmentList(_serialization.Model):
    """List of security sub-assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2019_01_01_preview.models.SecuritySubAssessment]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecuritySubAssessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerVulnerabilityProperties(AdditionalData):
    """Additional context fields for server vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar assessed_resource_type: Sub-assessment resource type. Required. Known values are:
     "SqlServerVulnerability", "ContainerRegistryVulnerability", and "ServerVulnerability".
    :vartype assessed_resource_type: str or
     ~azure.mgmt.security.v2019_01_01_preview.models.AssessedResourceType
    :ivar type: Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information
     Gathered.
    :vartype type: str
    :ivar cvss: Dictionary from cvss version to cvss details object.
    :vartype cvss: dict[str, ~azure.mgmt.security.v2019_01_01_preview.models.CVSS]
    :ivar patchable: Indicates whether a patch is available or not.
    :vartype patchable: bool
    :ivar cve: List of CVEs.
    :vartype cve: list[~azure.mgmt.security.v2019_01_01_preview.models.CVE]
    :ivar threat: Threat name.
    :vartype threat: str
    :ivar published_time: Published time.
    :vartype published_time: ~datetime.datetime
    :ivar vendor_references:
    :vartype vendor_references:
     list[~azure.mgmt.security.v2019_01_01_preview.models.VendorReference]
    """

    _validation = {
        "assessed_resource_type": {"required": True},
        "type": {"readonly": True},
        "cvss": {"readonly": True},
        "patchable": {"readonly": True},
        "cve": {"readonly": True},
        "threat": {"readonly": True},
        "published_time": {"readonly": True},
        "vendor_references": {"readonly": True},
    }

    _attribute_map = {
        "assessed_resource_type": {"key": "assessedResourceType", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "cvss": {"key": "cvss", "type": "{CVSS}"},
        "patchable": {"key": "patchable", "type": "bool"},
        "cve": {"key": "cve", "type": "[CVE]"},
        "threat": {"key": "threat", "type": "str"},
        "published_time": {"key": "publishedTime", "type": "iso-8601"},
        "vendor_references": {"key": "vendorReferences", "type": "[VendorReference]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessed_resource_type: str = "ServerVulnerabilityAssessment"
        self.type = None
        self.cvss = None
        self.patchable = None
        self.cve = None
        self.threat = None
        self.published_time = None
        self.vendor_references = None


class SqlServerVulnerabilityProperties(AdditionalData):
    """Details of the resource that was assessed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar assessed_resource_type: Sub-assessment resource type. Required. Known values are:
     "SqlServerVulnerability", "ContainerRegistryVulnerability", and "ServerVulnerability".
    :vartype assessed_resource_type: str or
     ~azure.mgmt.security.v2019_01_01_preview.models.AssessedResourceType
    :ivar type: The resource type the sub assessment refers to in its resource details.
    :vartype type: str
    :ivar query: The T-SQL query that runs on your SQL database to perform the particular check.
    :vartype query: str
    """

    _validation = {
        "assessed_resource_type": {"required": True},
        "type": {"readonly": True},
        "query": {"readonly": True},
    }

    _attribute_map = {
        "assessed_resource_type": {"key": "assessedResourceType", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessed_resource_type: str = "SqlServerVulnerability"
        self.type = None
        self.query = None


class SubAssessmentStatus(_serialization.Model):
    """Status of the sub-assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Programmatic code for the status of the assessment. Known values are: "Healthy",
     "Unhealthy", and "NotApplicable".
    :vartype code: str or ~azure.mgmt.security.v2019_01_01_preview.models.SubAssessmentStatusCode
    :ivar cause: Programmatic code for the cause of the assessment status.
    :vartype cause: str
    :ivar description: Human readable description of the assessment status.
    :vartype description: str
    :ivar severity: The sub-assessment severity level. Known values are: "Low", "Medium", and
     "High".
    :vartype severity: str or ~azure.mgmt.security.v2019_01_01_preview.models.Severity
    """

    _validation = {
        "code": {"readonly": True},
        "cause": {"readonly": True},
        "description": {"readonly": True},
        "severity": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "cause": {"key": "cause", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.cause = None
        self.description = None
        self.severity = None


class SuppressionAlertsScope(_serialization.Model):
    """SuppressionAlertsScope.

    All required parameters must be populated in order to send to Azure.

    :ivar all_of: All the conditions inside need to be true in order to suppress the alert.
     Required.
    :vartype all_of: list[~azure.mgmt.security.v2019_01_01_preview.models.ScopeElement]
    """

    _validation = {
        "all_of": {"required": True},
    }

    _attribute_map = {
        "all_of": {"key": "allOf", "type": "[ScopeElement]"},
    }

    def __init__(self, *, all_of: List["_models.ScopeElement"], **kwargs: Any) -> None:
        """
        :keyword all_of: All the conditions inside need to be true in order to suppress the alert.
         Required.
        :paramtype all_of: list[~azure.mgmt.security.v2019_01_01_preview.models.ScopeElement]
        """
        super().__init__(**kwargs)
        self.all_of = all_of


class VendorReference(_serialization.Model):
    """Vendor reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar title: Link title.
    :vartype title: str
    :ivar link: Link url.
    :vartype link: str
    """

    _validation = {
        "title": {"readonly": True},
        "link": {"readonly": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "link": {"key": "link", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.title = None
        self.link = None
